/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.util.ControlUtil;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigItemInfo;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;
import kd.ebg.egf.common.utils.log.OperationLogUtil;

public class BankBusinessConfigFormPlugin
extends AbstractBillPlugIn
implements ClickListener {
    private static final String ENTITY_KEY_BANK_BUSINESS = "aqap_bank_business";
    private static final String ENTITY_KEY_BUSINESSPROERTY_CONFIG = "aqap_object_properties";
    private static final String ENTITY_KEY_BANK = "aqap_bank";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String CONTAINER_KEY_CONTAINER = "conentpanel";
    private PropertyConfigInfo myPropertyConfigInfo;
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BankBusinessConfigFormPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (kd.ebg.aqap.formplugin.util.StringUtils.equals(fieldKey, "IS_OPEN_PAY_FOR_SALARY")) {
            this.setShowOrHideSalary();
        }
        this.setFieldShowOrHide();
    }

    private void setFieldShowOrHide() {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfigItems(this.getBankVersion());
        List newPropertyConfigItemInfos = propertyConfigInfo.getConfigItems().stream().filter(b -> b.getShowByFieldAndVal() != null).collect(Collectors.toList());
        if (newPropertyConfigItemInfos != null) {
            for (PropertyConfigItemInfo propertyConfigItemInfo : newPropertyConfigItemInfos) {
                String val = "";
                try {
                    ShowByFieldAndVal showByFieldAndVal = propertyConfigItemInfo.getShowByFieldAndVal();
                    val = (String)this.getModel().getValue(showByFieldAndVal.getFieldName());
                    String showVal = showByFieldAndVal.getFieldVal();
                    this.getView().setVisible(Boolean.valueOf(val.equalsIgnoreCase(showVal)), new String[]{propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH)});
                }
                catch (Exception exception) {}
            }
        }
    }

    private PropertyConfigInfo getBankConfigItems(String bankVersion) {
        return this.infoService.getBankBusinessConfig(bankVersion);
    }

    private void setShowOrHideSalary() {
        String isOpenSalary = "";
        try {
            isOpenSalary = (String)this.getModel().getValue("IS_OPEN_PAY_FOR_SALARY");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("true".equalsIgnoreCase(isOpenSalary)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"SALARY_SELECT".toLowerCase(Locale.ENGLISH), "SALARY_SAME_BANK".toLowerCase(Locale.ENGLISH), "SALARY_OTHER_BANK".toLowerCase(Locale.ENGLISH), "SALARY_BATCH_SIZE".toLowerCase(Locale.ENGLISH), "SALARY_DETAIL".toLowerCase(Locale.ENGLISH), "SALARY_DETAIL_BANK".toLowerCase(Locale.ENGLISH)});
        } else if ("false".equalsIgnoreCase(isOpenSalary)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"SALARY_SELECT".toLowerCase(Locale.ENGLISH), "SALARY_SAME_BANK".toLowerCase(Locale.ENGLISH), "SALARY_OTHER_BANK".toLowerCase(Locale.ENGLISH), "SALARY_BATCH_SIZE".toLowerCase(Locale.ENGLISH), "SALARY_DETAIL".toLowerCase(Locale.ENGLISH), "SALARY_DETAIL_BANK".toLowerCase(Locale.ENGLISH)});
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        String bankVersion = this.getBankVersion();
        this.createDynamicPanel(bankVersion);
        this.getPageCache().put("hasAddToContainer", "true");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BankBusinessConfigPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    String getUniqueRule() {
        String bankVersionId = this.getBankVersion();
        BankMetaDataCollector impl = BankBundleManager.getInstance().getBankMetaDataCollectorImpl(bankVersionId);
        Map map = impl.getDetailUniqueRule();
        if (map == null || map.isEmpty()) {
            return ResManager.loadKDString((String)"\u65e0", (String)"BankBusinessConfigFormPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        }
        StringBuilder uniqueRule = new StringBuilder();
        String split = "|";
        for (Map.Entry entryKey : map.entrySet()) {
            uniqueRule.append((String)entryKey.getKey()).append(split);
        }
        String result = uniqueRule.toString();
        result = result.substring(0, result.length() - 1);
        return result;
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("custom_id", (Object)RequestContext.get().getTenantId());
        PropertyConfigInfo propertyConfigInfo = this.getBankBusinessConfig(this.getBankVersion());
        List<PropertyConfigItemInfo> propertyConfigItemInfos = propertyConfigInfo.getConfigItems();
        propertyConfigItemInfos.stream().forEach(propertyConfigItemInfo -> {
            String value;
            QFilter filter1;
            QFilter filter;
            QFilter[] filters;
            DynamicObject dynamicObject;
            if (CollectionUtil.isNotEmpty(propertyConfigItemInfo.getDefaultValues())) {
                if (ConfigInputType.TEXTAREA.getInputType().equalsIgnoreCase(propertyConfigItemInfo.getInputType())) {
                    StringBuilder sb = new StringBuilder();
                    List<String> list = propertyConfigItemInfo.getDefaultValues();
                    for (int i = 0; i < list.size(); ++i) {
                        sb.append(list.get(i));
                        if (i >= list.size() - 1) continue;
                        sb.append("\n");
                    }
                    this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), (Object)sb.toString());
                } else {
                    this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), (Object)propertyConfigItemInfo.getDefaultValues().get(0));
                }
            } else if ("detail_unique_rule_show".equalsIgnoreCase(propertyConfigItemInfo.getKey())) {
                this.getModel().getDataEntity().set("detail_unique_rule_show", (Object)this.getUniqueRule());
            } else if ("detail_note_select".equalsIgnoreCase(propertyConfigItemInfo.getKey())) {
                String value2;
                QFilter filter12;
                QFilter filter2 = new QFilter("object_id", "=", (Object)this.getBankVersion());
                QFilter[] filters2 = new QFilter[]{filter2, filter12 = new QFilter("attr_key", "=", (Object)"detail_note_select")};
                DynamicObject dynamicObject2 = QueryServiceHelper.queryOne((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG, (String)"attr_key, attr_value", (QFilter[])filters2);
                if (dynamicObject2 != null && kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(value2 = dynamicObject2.getString("attr_value"))) {
                    this.getModel().setValue("detail_note_select", (Object)value2);
                }
            } else if ("detail_note_select_detail".equalsIgnoreCase(propertyConfigItemInfo.getKey()) && (dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG, (String)"attr_key, attr_value", (QFilter[])(filters = new QFilter[]{filter = new QFilter("object_id", "=", (Object)this.getBankVersion()), filter1 = new QFilter("attr_key", "=", (Object)"detail_note_select_detail")}))) != null && kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(value = dynamicObject.getString("attr_value"))) {
                this.getModel().setValue("detail_note_select_detail", (Object)value);
            }
            if (propertyConfigItemInfo.isHide()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH)});
            }
        });
        this.setShowOrHideSalary();
        this.updateCustomNote();
        this.setFieldShowOrHide();
    }

    private void updateCustomNote() {
        String customnoteStr = this.getView().getPageCache().get("customnote");
        if (kd.ebg.aqap.formplugin.util.StringUtils.isEmpty(customnoteStr)) {
            return;
        }
        List list = SerializationUtils.fromJsonStringToList((String)customnoteStr, Map.class);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                sb.append(item.get("field"));
                String logic = (String)item.get("logic");
                if (logic.equalsIgnoreCase("and")) {
                    sb.append(",");
                    continue;
                }
                sb.append("/");
            }
            this.getModel().setValue("detail_note_select", (Object)sb.substring(0, sb.length() - 1));
        } else {
            this.getModel().setValue("detail_note_select", (Object)"");
            this.getModel().setValue("detail_note_select_detail", (Object)"");
        }
    }

    public void afterLoadData(EventObject e) {
        String bankVersion = this.getBankVersion();
        PropertyConfigInfo propertyConfigInfo = this.getBankBusinessConfig(bankVersion);
        HashMap fieldTypeMap = new HashMap(16);
        propertyConfigInfo.getConfigItems().stream().forEach(p -> fieldTypeMap.put(p.getKey(), p.getInputType()));
        QFilter filter = new QFilter("object_id", "=", (Object)bankVersion);
        QFilter filter1 = new QFilter("object_name", "=", (Object)propertyConfigInfo.getPropertyName());
        QFilter[] filters = new QFilter[]{filter, filter1};
        DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG, (String)"attr_key, attr_value", (QFilter[])filters);
        HashSet dbDataSet = new HashSet(1);
        if (CollectionUtil.isNotEmpty((Collection)datas)) {
            datas.stream().forEach(data -> {
                String configid = data.getString("attr_key");
                String value = data.getString("attr_value");
                try {
                    if (ConfigInputType.DATE.getInputType().equals(fieldTypeMap.get(configid))) {
                        Date date = DateUtil.string2Date((String)value, (String)DATE_FORMAT);
                        this.getModel().getDataEntity().set(configid, (Object)date);
                    } else if ("detail_unique_rule_show".equalsIgnoreCase(configid)) {
                        this.getModel().getDataEntity().set("detail_unique_rule_show", (Object)this.getUniqueRule());
                    } else {
                        this.getModel().getDataEntity().set(configid, (Object)value);
                    }
                    dbDataSet.add(configid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        propertyConfigInfo.getConfigItems().stream().forEach(propertyConfigItemInfo -> {
            if (!dbDataSet.contains(propertyConfigItemInfo.getKey()) && CollectionUtil.isNotEmpty(propertyConfigItemInfo.getDefaultValues())) {
                if (ConfigInputType.TEXTAREA.getInputType().equalsIgnoreCase(propertyConfigItemInfo.getInputType())) {
                    StringBuilder sb = new StringBuilder();
                    List<String> list = propertyConfigItemInfo.getDefaultValues();
                    for (int i = 0; i < list.size(); ++i) {
                        sb.append(list.get(i));
                        if (i >= list.size() - 1) continue;
                        sb.append("\n");
                    }
                    this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), (Object)sb.toString());
                } else {
                    this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), (Object)propertyConfigItemInfo.getDefaultValues().get(0));
                }
            } else if ("detail_unique_rule_show".equalsIgnoreCase(propertyConfigItemInfo.getKey())) {
                this.getModel().getDataEntity().set("detail_unique_rule_show", (Object)this.getUniqueRule());
            }
            if (propertyConfigItemInfo.isHide()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH)});
            }
        });
        this.setShowOrHideSalary();
        this.setFieldShowOrHide();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String bankVersion = this.getBankVersion();
        List<FlexPanelAp> FieldsetPanelApList = this.createDynamicPanel(bankVersion);
        Container myFldPanel = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        FieldsetPanelApList.stream().forEach(fieldsetPanelAp -> myFldPanel.getItems().addAll(((Container)fieldsetPanelAp.buildRuntimeControl()).getItems()));
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getPropertyConfigItemInfoList(this.getBankVersion());
        propertyConfigItemInfos.stream().forEach(propertyConfigItemInfo -> {
            if (kd.ebg.aqap.formplugin.util.StringUtils.equals(propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH), e.getKey())) {
                if (ConfigInputType.DATE.getInputType().equals(propertyConfigItemInfo.getInputType())) {
                    DateEdit edit = new DateEdit();
                    edit.setKey(propertyConfigItemInfo.getKey());
                    edit.setView(this.getView());
                    e.setControl((Control)edit);
                } else {
                    TextEdit textEdit = new TextEdit();
                    textEdit.setKey(propertyConfigItemInfo.getKey());
                    textEdit.setView(this.getView());
                    e.setControl((Control)textEdit);
                }
            }
        });
    }

    public String getBankVersion() {
        if (this.getView() == null) {
            return "";
        }
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("tree_parent_id");
        if (jsonObject == null) {
            Long bankBusinessid = (Long)baseShowParameter.getPkId();
            if (bankBusinessid != null) {
                return this.getBankVersionByBusinessId(bankBusinessid);
            }
            return (String)baseShowParameter.getCustomParam("bankVersion");
        }
        return this.getBankVersion(jsonObject);
    }

    public String getBankVersion(JSONObject jsonObject) {
        String groupKey = jsonObject.getString("value");
        return this.getBankVersion(groupKey);
    }

    public String getBankVersion(String id) {
        DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY_BANK, (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(id))});
        String bankVersion = (String)((DynamicObject)datas.get(0)).get("number");
        return bankVersion;
    }

    public String getBankVersionByBusinessId(Long id) {
        DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY_BANK_BUSINESS, (String)"group.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        String bankVersion = (String)((DynamicObject)datas.get(0)).get("group.number");
        return bankVersion;
    }

    private List<FlexPanelAp> createDynamicPanel(String bankVersion) {
        HashMap<String, Integer> sortRule = new HashMap<String, Integer>(8);
        sortRule.put("default", 0);
        sortRule.put(BankPropertyConfigType.SAFE_PREVENT_DUP.getName(), 1);
        sortRule.put(BankPropertyConfigType.BAL_DETAIL_PARAM.getName(), 2);
        sortRule.put(BankPropertyConfigType.PAY_BIZ_PARAM.getName(), 3);
        sortRule.put(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName(), 4);
        ArrayList<FlexPanelAp> result = new ArrayList<FlexPanelAp>(1);
        String hasAddToContainer = this.getPageCache().get("hasAddToContainer");
        List<PropertyConfigItemInfo> configItemInfos = this.getPropertyConfigItemInfoList(bankVersion);
        TreeMap map = new TreeMap((a, b) -> {
            if (sortRule.getOrDefault(a, 999) - sortRule.getOrDefault(b, 999) == 0) {
                return a.compareTo((String)b);
            }
            return sortRule.getOrDefault(a, 999) - sortRule.getOrDefault(b, 999);
        });
        configItemInfos.stream().forEach(propertyConfigItemInfo -> {
            String type = propertyConfigItemInfo.getType() == null ? "default" : propertyConfigItemInfo.getType();
            List propertyConfigItemInfos = map.computeIfAbsent(type, k -> new ArrayList(1));
            propertyConfigItemInfos.add(propertyConfigItemInfo);
        });
        Container container = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        for (Map.Entry entry : map.entrySet()) {
            FlexPanelAp flex = ControlUtil.createFlexPanelAp((String)entry.getKey());
            ControlUtil.addFieldsetPanelApItems(flex, (List)entry.getValue());
            if (hasAddToContainer == null) {
                container.addControls(Collections.singletonList(flex.createControl()));
            }
            result.add(flex);
        }
        return result;
    }

    public List<PropertyConfigItemInfo> getPropertyConfigItemInfoList(String bankVersion) {
        PropertyConfigInfo propertyConfigInfo = this.getBankBusinessConfig(bankVersion);
        if (propertyConfigInfo != null) {
            return propertyConfigInfo.getConfigItems();
        }
        return null;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getPropertyConfigItemInfoList(this.getBankVersion());
        propertyConfigItemInfos.stream().forEach(p -> {
            if (ConfigInputType.DATE.getInputType().equals(p.getInputType())) {
                DateProp prop = new DateProp();
                prop.setName(p.getKey());
                prop.setDisplayName(new LocaleString(p.getName()));
                prop.setDbIgnore(true);
                prop.setAlias("");
                newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
            } else {
                TextProp textProp = ControlUtil.buildTextPorp(p.getKey(), p.getName());
                newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        this.addClickListeners(new String[]{"detail_note_select"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("detail_note_select".equalsIgnoreCase(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("aqap_custom_note_config");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "custom_note_select");
            formShowParameter.setCloseCallBack(callBack);
            formShowParameter.setCustomParam("bankversion", (Object)this.getBankVersion());
            formShowParameter.setCustomParam("customnoteselectdetail", this.getModel().getValue("detail_note_select_detail"));
            this.getView().showForm(formShowParameter);
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            String value;
            String bankVersion;
            DynamicObjectCollection bankBusinessDatas;
            String statusName = ((BaseShowParameter)this.getView().getFormShowParameter()).getBillStatus().name();
            if ("ADDNEW".equalsIgnoreCase(statusName) && CollectionUtil.isNotEmpty((Collection)(bankBusinessDatas = QueryServiceHelper.query((String)ENTITY_KEY_BANK_BUSINESS, (String)"id", (QFilter[])new QFilter("group.number", "=", (Object)(bankVersion = (String)this.getModel().getDataEntity().get("group.number"))).toArray())))) {
                this.getView().showTipNotification(MultiLang.getAddNewRepeatTip());
                args.setCancel(true);
                return;
            }
            boolean hasDetailNote = this.getModel().getDataEntity().containsProperty("detail_note_select");
            if (hasDetailNote && kd.ebg.aqap.formplugin.util.StringUtils.isEmpty(value = (String)this.getModel().getDataEntity().get("detail_note_select"))) {
                this.getModel().getDataEntity().set("detail_note_select_detail", (Object)"");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (kd.ebg.aqap.formplugin.util.StringUtils.equals("bar_save", evt.getItemKey())) {
            String statusName = ((BaseShowParameter)this.getView().getFormShowParameter()).getBillStatus().name();
            IDataModel model = this.getModel();
            String bankVersion = (String)model.getDataEntity().get("group.number");
            PropertyConfigInfo propertyConfigInfo = this.getBankBusinessConfig(bankVersion);
            ArrayList dynamicObjectSaveList = new ArrayList(16);
            ArrayList operateLogList = new ArrayList(16);
            List<PropertyConfigItemInfo> configItems = propertyConfigInfo.getConfigItems();
            configItems.stream().forEach(p -> {
                String value;
                if (ConfigInputType.DATE.getInputType().equals(p.getInputType())) {
                    Date date = (Date)model.getValue(p.getKey());
                    value = DateUtil.formatDate((Date)date, (String)DATE_FORMAT);
                } else {
                    value = (String)model.getValue(p.getKey());
                }
                value = value != null ? value.trim() : value;
                String name = p.getMlName().loadKDString();
                if (kd.ebg.aqap.formplugin.util.StringUtils.isEmpty(name)) {
                    name = p.getName();
                }
                operateLogList.add(this.operateLog(bankVersion, name, p.getKey(), value, bankVersion, propertyConfigInfo.getPropertyName()));
                dynamicObjectSaveList.add(this.getDataEntity((PropertyConfigItemInfo)p, bankVersion, propertyConfigInfo.getPropertyName(), value));
            });
            try (TXHandle h = TX.requiresNew();){
                if ("ADDNEW".equalsIgnoreCase(statusName)) {
                    DynamicObjectCollection bankBusinessDatas = QueryServiceHelper.query((String)ENTITY_KEY_BANK_BUSINESS, (String)"id", (QFilter[])new QFilter("group.number", "=", (Object)bankVersion).toArray());
                    if (CollectionUtil.isNotEmpty((Collection)bankBusinessDatas)) {
                        return;
                    }
                } else if ("EDIT".equalsIgnoreCase(statusName)) {
                    QFilter filter = new QFilter("object_id", "=", (Object)bankVersion);
                    QFilter filter1 = new QFilter("object_name", "=", (Object)propertyConfigInfo.getPropertyName());
                    QFilter[] filters = new QFilter[]{filter, filter1};
                    DeleteServiceHelper.delete((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG, (QFilter[])filters);
                }
                boolean result = this.save(dynamicObjectSaveList.toArray(new DynamicObject[dynamicObjectSaveList.size()]));
                if (result) {
                    for (OpLogAppInfo opLogAppInfo : operateLogList) {
                        if (!StringUtil.isNotNil(opLogAppInfo.getBizAppID())) continue;
                        OperationLogUtil.recordInvoke((OpLogAppInfo)opLogAppInfo);
                    }
                    this.updateMasterID(bankVersion, propertyConfigInfo.getPropertyName());
                }
            }
        }
    }

    private void updateMasterID(String bankVersion, String propertyName) {
        DynamicObject[] dynamicObjects;
        QFilter filter = QFilter.of((String)"object_id=? and object_name=?", (Object[])new Object[]{bankVersion, propertyName});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG, (String)"id,masterid", (QFilter[])filter.toArray())) {
            dynamicObject.set("masterid", (Object)dynamicObject.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private OpLogAppInfo operateLog(String bankVersionId, String name, String key, String newValue, String objectId, String objectName) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "BusinessPropertyFormPlugin_12", "ebg-aqap-formplugin");
        QFilter filter = QFilter.of((String)"attr_key=?", (Object[])new Object[]{key});
        filter.and(new QFilter("object_id", "=", (Object)objectId));
        filter.and(new QFilter("object_name", "=", (Object)objectName));
        DynamicObject object = QueryCacheUtil.getSingleDynamicObject((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG, (String)"attr_key, attr_value", (QFilter[])filter.toArray());
        newValue = this.infoService.getBankBusinessConfigSourceName(bankVersionId, key, newValue);
        if (object != null) {
            String value = object.getString("attr_value");
            if (!kd.ebg.aqap.formplugin.util.StringUtils.equalsIgnoreCase(newValue, value = this.infoService.getBankBusinessConfigSourceName(bankVersionId, key, value))) {
                if (kd.ebg.aqap.formplugin.util.StringUtils.isEmpty(name)) {
                    name = key;
                }
                MultiLangEnumBridge descBridge = new MultiLangEnumBridge("%1$s\u66f4\u65b0%2$s:[%3$s] -> [%4$s]\u3002", "BusinessPropertyFormPlugin_101", "ebg-aqap-formplugin");
                appLogInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{bankVersionId, name, value, newValue});
            }
        } else {
            MultiLangEnumBridge descBridge = new MultiLangEnumBridge("%1$s\u65b0\u589e%2$s:[%3$s]\u3002", "BusinessPropertyFormPlugin_111", "ebg-aqap-formplugin");
            appLogInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{bankVersionId, name, newValue});
        }
        return appLogInfo;
    }

    PropertyConfigInfo getBankBusinessConfig(String bankVersion) {
        if (this.myPropertyConfigInfo != null) {
            return this.myPropertyConfigInfo;
        }
        this.myPropertyConfigInfo = this.infoService.getBankBusinessConfig(bankVersion);
        return this.myPropertyConfigInfo;
    }

    OperationResult save(PropertyConfigItemInfo configItemInfo, String objectId, String objectName, String value) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG);
        String customID = RequestContext.get().getTenantId();
        dataEntity.set("attr_key", (Object)configItemInfo.getKey());
        dataEntity.set("attr_value", (Object)value);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)customID);
        OperationResult result = SaveServiceHelper.saveOperate((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        return result;
    }

    DynamicObject getDataEntity(PropertyConfigItemInfo configItemInfo, String objectId, String objectName, String value) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_BUSINESSPROERTY_CONFIG);
        String customID = RequestContext.get().getTenantId();
        dataEntity.set("attr_key", (Object)configItemInfo.getKey());
        dataEntity.set("attr_value", (Object)value);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)customID);
        return dataEntity;
    }

    boolean save(DynamicObject[] dataEntities) {
        try {
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
        catch (Throwable t) {
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "BusinessPropertyFormPlugin_12", "ebg-aqap-formplugin");
            MultiLangEnumBridge descBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", "BusinessPropertyFormPlugin_13", "ebg-aqap-formplugin");
            OperationLogUtil.recordInvoke((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{t.toString()});
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("custom_note_select".equals(e.getActionId()) && e.getReturnData() != null) {
            this.getModel().setValue("detail_note_select_detail", (Object)SerializationUtils.toJsonString((Object)e.getReturnData()));
            this.getView().getPageCache().put("customnote", SerializationUtils.toJsonString((Object)e.getReturnData()));
            this.updateCustomNote();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FieldEdit fieldEdit = (FieldEdit)this.getControl("detail_note_select_detail");
        TextProp textProp = (TextProp)fieldEdit.getProperty();
        textProp.setMaxLenth(512);
    }
}

