/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.aqap.formplugin.plugin.paramsconfig.BusinessConfigListPlugin;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class BankBusinessConfigListPlugin
extends EbcAddBankListPlugin
implements ClickListener {
    private static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    private static final String ENTITY_KEY_BANK_BUSINESS = "aqap_bank_business";
    private static final String KEY_BANK = "aqap_bank";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);

    public void setFilter(SetFilterEvent e) {
        e.addCustomQFilter(new QFilter("enable", "=", (Object)"1"));
    }

    public void beforeBindData(EventObject e) {
        ArrayList<DynamicObject> updateBankBusinessList = new ArrayList<DynamicObject>(1);
        Map<String, DynamicObject> allBankMap = this.getAllBanks();
        List<String> hasConfigBankVersions = this.getHasConfigBankVersion();
        HashMap<String, Long> bankBusinessMap = new HashMap<String, Long>(1);
        DynamicObject[] bankBusinessDatas = BusinessDataServiceHelper.load((String)ENTITY_KEY_BANK_BUSINESS, (String)"group,enable", (QFilter[])new QFilter("status", "=", (Object)Character.valueOf('A')).toArray());
        if (bankBusinessDatas != null) {
            for (DynamicObject dynamicObject : bankBusinessDatas) {
                Long id = dynamicObject.getLong("group.id");
                String name = dynamicObject.getString("group.number");
                bankBusinessMap.put(name, id);
                DynamicObject bank = allBankMap.get(name);
                if (dynamicObject.getString("enable").equalsIgnoreCase(bank.getString("enable"))) continue;
                dynamicObject.set("enable", (Object)bank.getString("enable"));
                updateBankBusinessList.add(dynamicObject);
            }
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(1);
        for (String bankVersion : hasConfigBankVersions) {
            if (bankBusinessMap.containsKey(bankVersion) || !allBankMap.containsKey(bankVersion)) continue;
            DynamicObject bank = allBankMap.get(bankVersion);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_BANK_BUSINESS, (boolean)true, (OperateOption)OperateOption.create());
            dynamicObject.set("group", (Object)bank);
            dynamicObject.set("status", (Object)Character.valueOf('A'));
            dynamicObject.set("enable", (Object)bank.getString("enable"));
            dynamicObject.set("custom_id", (Object)RequestContext.get().getTenantId());
            saveList.add(dynamicObject);
        }
        if (!saveList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
        }
        SaveServiceHelper.update((DynamicObject[])updateBankBusinessList.toArray(new DynamicObject[updateBankBusinessList.size()]));
    }

    private Map<String, DynamicObject> getAllBanks() {
        String entityName = KEY_BANK;
        QFilter filter = QFilter.of((String)"enable=? or enable=?", (Object[])new Object[]{"1", "0"});
        HashMap dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])filter.toArray());
        if (dynamicObjectMap == null) {
            dynamicObjectMap = new HashMap(1);
        }
        HashMap<String, DynamicObject> bankMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            String bankVersionID = dynamicObject.getString("number");
            bankMap.put(bankVersionID, dynamicObject);
        }
        return bankMap;
    }

    private List<String> getHasConfigBankVersion() {
        ArrayList<String> bankVersionList = new ArrayList<String>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct A.fobject_id from t_aqap_object_properties A  where A.fobject_id in (select B.fnumber from t_aqap_bank B where B.fenable='1')", new Object[0]);
        DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"ebg"), (SqlBuilder)sqlBuilder);
        if (!ds.isEmpty()) {
            for (Row row : ds) {
                String objectId = row.getString(0);
                bankVersionList.add(objectId);
            }
        }
        return bankVersionList;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)formOperate.getOperateKey())) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Map focusNode = treeView.getTreeState().getFocusNode();
            String text = (String)focusNode.get("text");
            if (ResManager.loadKDString((String)"\u5168\u90e8", (String)"BankBusinessConfigListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equalsIgnoreCase(text)) {
                this.getView().showTipNotification(MultiLang.getSelectBankTip());
                args.setCancel(true);
                return;
            }
            String id = (String)focusNode.get("id");
            QFilter filter = QFilter.of((String)"id = ?", (Object[])new Object[]{Long.parseLong(id)});
            DynamicObjectCollection datas = QueryServiceHelper.query((String)KEY_BANK, (String)"number", (QFilter[])filter.toArray());
            String bankVersion = (String)((DynamicObject)datas.get(0)).get("number");
            DynamicObjectCollection bankBusinessDatas = QueryServiceHelper.query((String)ENTITY_KEY_BANK_BUSINESS, (String)"id", (QFilter[])new QFilter("group.number", "=", (Object)bankVersion).toArray());
            if (CollectionUtil.isNotEmpty((Collection)bankBusinessDatas)) {
                this.getView().showTipNotification(MultiLang.getAddNewRepeatTip());
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                listSelectedRowCollection.forEach(selectedRow -> {
                    Long bankBusinessId = (Long)selectedRow.getPrimaryKeyValue();
                    DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY_BANK_BUSINESS, (String)"group.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankBusinessId)});
                    String bankVersion = (String)((DynamicObject)datas.get(0)).get("group.number");
                    String businessName = this.infoService.getBusinessName(bankVersion);
                    QFilter filter = new QFilter("object_id", "=", (Object)bankVersion);
                    QFilter filter1 = new QFilter("object_name", "=", (Object)businessName);
                    QFilter[] filters = new QFilter[]{filter, filter1};
                    DeleteServiceHelper.delete((String)ENTITY_KEY_OBJECT_PROPERTIES, (QFilter[])filters);
                });
            }
        } else if (StringUtils.equals((CharSequence)"export_data", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"import_data", (CharSequence)formOperate.getOperateKey())) {
            List<String> bankVersionList = StringUtils.equals((CharSequence)"import_data", (CharSequence)formOperate.getOperateKey()) ? this.getUsedBankVersion() : this.getSelectedBankVersion(args);
            if (!bankVersionList.isEmpty()) {
                ListShowParameter listShowParameter = this.createListShowParameter(BusinessConfigListPlugin.ENTITY_NAME, bankVersionList, formOperate.getOperateKey());
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u94f6\u884c\u7248\u672c\u5e76\u4fdd\u5b58\u94f6\u884c\u4e1a\u52a1\u914d\u7f6e\u3002", (String)"BankBusinessConfigListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<String> getSelectedBankVersion(BeforeDoOperationEventArgs args) {
        ArrayList<String> bankVersionList = new ArrayList<String>(16);
        ArrayList<Long> pkIDs = new ArrayList<Long>(16);
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        for (ListSelectedRow row : listSelectedData) {
            Long pkId = (Long)row.getPrimaryKeyValue();
            pkIDs.add(pkId);
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)ENTITY_KEY_BANK_BUSINESS, (String)"group.number", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIDs)});
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String bankVersion = dynamicObject.getString("group.number");
            bankVersionList.add(bankVersion);
        }
        return bankVersionList;
    }

    private ListShowParameter createListShowParameter(String entityName, List<String> bankVersionList, String operateKey) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("");
        listShowParameter.setBillFormId(entityName);
        ListFilterParameter parameter = new ListFilterParameter();
        QFilter filter = new QFilter("object_id", "in", bankVersionList);
        parameter.setFilter(filter);
        listShowParameter.setListFilterParameter(parameter);
        listShowParameter.setCustomParam("operateKey", (Object)operateKey);
        return listShowParameter;
    }

    private List<String> getUsedBankVersion() {
        ArrayList<String> bankVersionList = new ArrayList<String>(16);
        String entityName = KEY_BANK;
        QFilter filter = QFilter.of((String)"enable=?", (Object[])new Object[]{"1"});
        Map maps = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"number", (QFilter[])filter.toArray());
        for (Map.Entry entry : maps.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            bankVersionList.add(dynamicObject.getString("number"));
        }
        return bankVersionList;
    }
}

