/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfigType;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigItemInfo;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.aqap.formplugin.util.FieldType;
import kd.ebg.aqap.formplugin.util.FieldUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;
import kd.ebg.egf.common.utils.log.OperationLogUtil;

public class BusinessPropertyFormPlugin
extends AbstractFormPlugin
implements IBillPlugin {
    private static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    private static final String ENTITY_KEY_BUSINESS_PROPERTIES = "aqap_business_property";
    private static final String CONTAINER_KEY_CONTAINER = "conentpanel";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private List<PropertyConfigInfo> myPropertyConfigInfos;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String cacheKeyPre = "password_";
    private static final String specialCode = "******";
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BusinessPropertyFormPlugin.class);

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals("OPEN_PROXY_AUTHOR", fieldKey)) {
            this.setFieldShowOrHideProxy();
        }
        this.setFieldShowOrHide();
    }

    public void setFieldShowOrHideProxy() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"PROXY_USER_NAME", "PROXY_USER_AUTHOR", "PROXY_SECRET", "PROXY_SECRET_VI"});
        String isUseOpenPaoxy = "true";
        try {
            isUseOpenPaoxy = (String)this.getModel().getDataEntity().get("OPEN_PROXY_AUTHOR");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Objects.equals(isUseOpenPaoxy, "on")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"proxy_user_name", "proxy_user_author", "proxy_secret", "proxy_secret_vi"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"proxy_user_name", "proxy_user_author", "proxy_secret", "proxy_secret_vi"});
        }
    }

    public void setFieldShowOrHide() {
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getConfigItems();
        List<Object> newPropertyConfigItemInfos = new ArrayList<PropertyConfigItemInfo>(16);
        newPropertyConfigItemInfos.addAll(propertyConfigItemInfos);
        newPropertyConfigItemInfos = newPropertyConfigItemInfos.stream().filter(b -> b.getShowByFieldAndVal() != null).collect(Collectors.toList());
        if (newPropertyConfigItemInfos != null) {
            for (PropertyConfigItemInfo propertyConfigItemInfo : newPropertyConfigItemInfos) {
                String val = "";
                try {
                    String name;
                    ShowByFieldAndVal showByFieldAndVal = propertyConfigItemInfo.getShowByFieldAndVal();
                    val = (String)this.getModel().getValue(showByFieldAndVal.getFieldName());
                    String showVal = showByFieldAndVal.getFieldVal();
                    if (showVal.startsWith("!")) {
                        showVal = showVal.replaceFirst("!", "");
                        this.getView().setVisible(Boolean.valueOf(!val.equals(showVal)), new String[]{propertyConfigItemInfo.getKey()});
                        name = "";
                        name = !val.equals(showVal) ? ResManager.loadKDString((String)"\u9690\u85cf", (String)"BusinessPropertyFormPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5c55\u793a", (String)"BusinessPropertyFormPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
                        if (!"upload".equalsIgnoreCase(propertyConfigItemInfo.getInputType())) continue;
                        this.getView().setVisible(Boolean.valueOf(!val.equals(showVal)), new String[]{"btn_" + propertyConfigItemInfo.getKey()});
                        continue;
                    }
                    this.getView().setVisible(Boolean.valueOf(val.equals(showVal)), new String[]{propertyConfigItemInfo.getKey()});
                    name = "";
                    name = !val.equals(showVal) ? ResManager.loadKDString((String)"\u9690\u85cf", (String)"BusinessPropertyFormPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5c55\u793a", (String)"BusinessPropertyFormPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
                    if (!"upload".equalsIgnoreCase(propertyConfigItemInfo.getInputType())) continue;
                    this.getView().setVisible(Boolean.valueOf(val.equals(showVal)), new String[]{"btn_" + propertyConfigItemInfo.getKey()});
                }
                catch (Exception exception) {}
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        this.createDynamicPanel(false);
        this.getPageCache().put("hasAddToContainer", "true");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BusinessPropertyConfigPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List<FieldsetPanelAp> FieldsetPanelApList = this.createDynamicPanel(true);
        Container myFldPanel = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        FieldsetPanelApList.stream().forEach(fieldsetPanelAp -> myFldPanel.getItems().addAll(((Container)fieldsetPanelAp.buildRuntimeControl()).getItems()));
        this.getView().createControlIndex(myFldPanel.getItems());
        List<PropertyConfigInfo> propertyConfigInfos = this.getCommonBusinessConfig();
        HashMap fieldTypeMap = new HashMap(16);
        if (propertyConfigInfos != null && propertyConfigInfos.size() > 0) {
            for (PropertyConfigInfo propertyConfigInfo : propertyConfigInfos) {
                propertyConfigInfo.getConfigItems().stream().forEach(p -> fieldTypeMap.put(p.getKey(), p.getInputType()));
                QFilter[] filters = new QFilter[]{new QFilter("object_id", "=", (Object)propertyConfigInfo.getPropertyConfigID()), new QFilter("object_name", "=", (Object)(ENTITY_KEY_BUSINESS_PROPERTIES.equalsIgnoreCase(this.getView().getEntityId()) ? "ebg" : "receipt"))};
                DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)"attr_key, attr_value", (QFilter[])filters);
                if (CollectionUtil.isNotEmpty((Collection)datas)) {
                    HashSet set = new HashSet(1);
                    datas.stream().forEach(data -> {
                        String configid = data.getString("attr_key");
                        String value = data.getString("attr_value");
                        String cacheKey = cacheKeyPre + configid;
                        if (this.getView().getPageCache().get(cacheKey) != null) {
                            this.getView().getPageCache().put(cacheKey, value);
                            value = specialCode;
                        }
                        try {
                            if (ConfigInputType.DATE.getInputType().equals(fieldTypeMap.get(configid))) {
                                Date date = DateUtil.string2Date((String)value, (String)DATE_FORMAT);
                                this.getModel().getDataEntity().set(configid, (Object)date);
                            } else {
                                this.getModel().getDataEntity().set(configid, (Object)value);
                            }
                            set.add(configid);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                    this.getConfigItems().stream().forEach(propertyConfigItemInfo -> {
                        if (!set.contains(propertyConfigItemInfo.getKey()) && CollectionUtil.isNotEmpty(propertyConfigItemInfo.getDefaultValues())) {
                            this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), (Object)propertyConfigItemInfo.getDefaultValues().get(0));
                        }
                    });
                    continue;
                }
                this.getConfigItems().stream().forEach(propertyConfigItemInfo -> {
                    if (CollectionUtil.isNotEmpty(propertyConfigItemInfo.getDefaultValues())) {
                        this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), (Object)propertyConfigItemInfo.getDefaultValues().get(0));
                    }
                });
            }
        }
        this.setFieldShowOrHide();
        this.setFieldShowOrHideProxy();
    }

    public List<PropertyConfigInfo> getCommonBusinessConfig() {
        if (CollectionUtil.isNotEmpty(this.myPropertyConfigInfos)) {
            return this.myPropertyConfigInfos;
        }
        this.myPropertyConfigInfos = this.infoService.getCommonBusinessConfig();
        return this.myPropertyConfigInfos;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List<PropertyConfigItemInfo> configItemInfos = this.getConfigItems();
        for (PropertyConfigItemInfo propertyConfigItemInfo : configItemInfos) {
            this.logger.info("onGetControl\u5168\u5c40\u53c2\u6570\u5c5e\u6027\uff1a" + propertyConfigItemInfo.getKey());
            if (!StringUtils.equals(propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH), e.getKey())) continue;
            if (ConfigInputType.DATE.getInputType().equals(propertyConfigItemInfo.getInputType())) {
                DateEdit edit = new DateEdit();
                edit.setKey(propertyConfigItemInfo.getKey());
                edit.setView(this.getView());
                e.setControl((Control)edit);
                continue;
            }
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(propertyConfigItemInfo.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    List<PropertyConfigItemInfo> getConfigItems() {
        ArrayList<PropertyConfigItemInfo> list = new ArrayList<PropertyConfigItemInfo>(16);
        List<PropertyConfigInfo> propertyConfigInfos = this.getCommonBusinessConfig();
        if (propertyConfigInfos != null && propertyConfigInfos.size() > 0) {
            for (PropertyConfigInfo propertyConfigInfo : propertyConfigInfos) {
                list.addAll(propertyConfigInfo.getConfigItems().stream().filter(c -> !"receipt".equalsIgnoreCase(BusinessPropertyConfigType.getTypeByName((String)c.getType()))).collect(Collectors.toList()));
            }
        }
        list.sort(Comparator.comparing(PropertyConfigItemInfo::getKey));
        return list;
    }

    private List<FieldsetPanelAp> createDynamicPanel(boolean isNeedResult) {
        ArrayList<FieldsetPanelAp> result = new ArrayList<FieldsetPanelAp>(1);
        String hasAddToContainer = this.getPageCache().get("hasAddToContainer");
        if (hasAddToContainer != null && !isNeedResult) {
            return result;
        }
        List<PropertyConfigItemInfo> configItemInfos = this.getConfigItems();
        HashMap<String, ArrayList<PropertyConfigItemInfo>> map = new HashMap<String, ArrayList<PropertyConfigItemInfo>>(16);
        for (PropertyConfigItemInfo propertyConfigItemInfo : configItemInfos) {
            String type = propertyConfigItemInfo.getType() == null ? "default" : propertyConfigItemInfo.getType();
            ArrayList<PropertyConfigItemInfo> propertyConfigItemInfos = (ArrayList<PropertyConfigItemInfo>)map.get(type);
            if (propertyConfigItemInfos == null) {
                propertyConfigItemInfos = new ArrayList<PropertyConfigItemInfo>(1);
                map.put(type, propertyConfigItemInfos);
            }
            propertyConfigItemInfos.add(propertyConfigItemInfo);
        }
        Container container = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        for (Map.Entry entry : map.entrySet()) {
            FieldsetPanelAp flex = this.createFieldsetPanelAp((String)entry.getKey());
            this.addFieldsetPanelApItems(flex, (List)entry.getValue());
            if (hasAddToContainer == null) {
                container.addControls(Collections.singletonList(flex.createControl()));
            }
            result.add(flex);
        }
        return result;
    }

    public void addFieldsetPanelApItems(FieldsetPanelAp flex, List<PropertyConfigItemInfo> propertyConfigItemInfos) {
        propertyConfigItemInfos.stream().forEach(p -> {
            FieldAp fieldAp;
            String name = FieldUtil.getName(p.getMlName(), p.getName());
            String desc = FieldUtil.getDesc(p.getMlDesc(), p.getDesc());
            List<String> sourceNames = FieldUtil.getSourceNames(p.getMlSourceNames(), p.getSourceNames());
            if (CollectionUtil.isNotEmpty(sourceNames) || ConfigInputType.SELECT.getInputType().equalsIgnoreCase(p.getInputType())) {
                fieldAp = FieldUtil.createComboField(name, p.getKey(), p.isReadonly(), p.isHide(), p.isMustInput(), desc, p.getSourceValues(), sourceNames);
            } else if (ConfigInputType.INTEGER.getInputType().equalsIgnoreCase(p.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, p.getKey(), p.isMustInput(), p.isReadonly(), FieldType.INTEGER, desc);
                FieldUtil.setIntegerFieldApDataScope(fieldAp, p.getMinValueNum(), p.getMaxValueNum());
            } else if (ConfigInputType.DATE.getInputType().equalsIgnoreCase(p.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, p.getKey(), p.isMustInput(), p.isReadonly(), FieldType.DATE, desc);
            } else if (ConfigInputType.TEXTAREA.getInputType().equalsIgnoreCase(p.getInputType())) {
                fieldAp = FieldUtil.createMultiTextField(name, p.getKey(), p.getMaxValueNum());
                FieldUtil.setFieldApReadOnly(fieldAp, p.isReadonly());
                FieldUtil.setFieldApTips(fieldAp, desc);
            } else if (ConfigInputType.PASSWORD.getInputType().equals(p.getInputType())) {
                String key = p.getKey();
                key = key.toUpperCase(Locale.ENGLISH);
                fieldAp = FieldUtil.createTextField(name, key, p.isReadonly(), p.isMustInput(), desc, true);
                String cacheKey = cacheKeyPre + p.getKey();
                if (this.getView().getPageCache().get(cacheKey) == null) {
                    this.getView().getPageCache().put(cacheKey, "");
                }
            } else {
                fieldAp = FieldUtil.createTextField(name, p.getKey());
                FieldUtil.setFieldApReadOnly(fieldAp, p.isReadonly());
                FieldUtil.setFieldApMustInput(fieldAp, p.isMustInput());
                FieldUtil.setFieldApTips(fieldAp, desc);
            }
            flex.getItems().add(fieldAp);
        });
    }

    public FieldsetPanelAp createFieldsetPanelAp(String type) {
        FieldsetPanelAp flex = new FieldsetPanelAp();
        flex.setKey(type);
        flex.setCollapsible(true);
        flex.setName(new LocaleString("default".equalsIgnoreCase(type) ? ResManager.loadKDString((String)"\u57fa\u7840\u53c2\u6570", (String)"BusinessPropertyFormPlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]) : BusinessPropertyConfigType.getDescByName((String)type)));
        flex.setGrow(1);
        flex.setShrink(0);
        Style style = new Style();
        Border border = new Border();
        border.setTop("10px #E2E7EF solid");
        style.setBorder(border);
        flex.setStyle(style);
        return flex;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getConfigItems();
        for (PropertyConfigItemInfo propertyConfigItemInfo : propertyConfigItemInfos) {
            this.logger.info("registDynamicProps\u5168\u5c40\u53c2\u6570\u5c5e\u6027\uff1a" + propertyConfigItemInfo.getKey());
            if (ConfigInputType.DATE.getInputType().equals(propertyConfigItemInfo.getInputType())) {
                DateProp prop = new DateProp();
                prop.setName(propertyConfigItemInfo.getKey());
                prop.setDisplayName(new LocaleString(propertyConfigItemInfo.getName()));
                prop.setDbIgnore(true);
                prop.setAlias("");
                newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
                continue;
            }
            TextProp textProp = this.buildTextPorp(propertyConfigItemInfo.getKey(), propertyConfigItemInfo.getName());
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
    }

    private TextProp buildTextPorp(String key, String name) {
        TextProp textProp = new TextProp();
        textProp.setName(key);
        textProp.setDisplayName(new LocaleString(name));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals("donothing", formOperate.getOperateKey())) {
            if (!this.checkDataValid()) {
                args.setCancel(true);
                this.getModel().putContextVariable("cancel_save", (Object)Boolean.TRUE);
                return;
            }
            this.getModel().putContextVariable("cancel_save", (Object)Boolean.FALSE);
        }
    }

    boolean checkDataValid() {
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals("bar_save_true", evt.getItemKey()) && this.getModel().getContextVariable("cancel_save") != null && !((Boolean)this.getModel().getContextVariable("cancel_save")).booleanValue()) {
            IDataModel model = this.getModel();
            String objectName = ENTITY_KEY_BUSINESS_PROPERTIES.equalsIgnoreCase(this.getView().getEntityId()) ? "ebg" : "receipt";
            ArrayList dynamicObjectSaveList = new ArrayList(16);
            ArrayList operateLogList = new ArrayList(16);
            List<PropertyConfigItemInfo> configItems = this.getConfigItems();
            configItems.stream().forEach(configItemInfo -> {
                String value;
                if (ConfigInputType.DATE.getInputType().equals(configItemInfo.getInputType())) {
                    Date date = (Date)model.getValue(configItemInfo.getKey());
                    value = DateUtil.formatDate((Date)date, (String)DATE_FORMAT);
                } else {
                    value = (String)model.getValue(configItemInfo.getKey());
                }
                value = value != null ? value.trim() : value;
                String name = configItemInfo.getMlName().loadKDString();
                if (StringUtils.isEmpty(name)) {
                    name = configItemInfo.getName();
                }
                operateLogList.add(this.operateLog(name, configItemInfo.getKey(), value));
                dynamicObjectSaveList.add(this.getDataEntity((PropertyConfigItemInfo)configItemInfo, "common_business", objectName, value, RequestContext.get().getTenantId()));
            });
            try (TXHandle h = TX.requiresNew();){
                this.delete("common_business", objectName);
                boolean result = this.save(dynamicObjectSaveList.toArray(new DynamicObject[dynamicObjectSaveList.size()]));
                if (result) {
                    for (OpLogAppInfo appInfo : operateLogList) {
                        if (!StringUtils.isNotEmpty(appInfo.getBizAppID())) continue;
                        OperationLogUtil.recordInvoke((OpLogAppInfo)appInfo);
                    }
                }
            }
        }
    }

    private OpLogAppInfo operateLog(String name, String key, String newValue) {
        OpLogAppInfo appInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "BusinessPropertyFormPlugin_12", "ebg-aqap-formplugin");
        QFilter filter = QFilter.of((String)"attr_key=?", (Object[])new Object[]{key});
        filter.and(new QFilter("object_id", "=", (Object)"common_business"));
        filter.and(new QFilter("object_name", "=", (Object)(ENTITY_KEY_BUSINESS_PROPERTIES.equalsIgnoreCase(this.getView().getEntityId()) ? "ebg" : "receipt")));
        DynamicObject object = QueryCacheUtil.getSingleDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)"attr_key, attr_value", (QFilter[])filter.toArray());
        newValue = this.infoService.getCommonBusinessConfigSourceName(key, newValue);
        if (object != null) {
            String value = object.getString("attr_value");
            if (!StringUtils.equalsIgnoreCase(newValue, value = this.infoService.getCommonBusinessConfigSourceName(key, value))) {
                if (StringUtils.isEmpty(name)) {
                    name = key;
                }
                MultiLangEnumBridge descBridge = new MultiLangEnumBridge("%1$s\uff1a\u66f4\u65b0[%2$s] -> [%3$s]\u3002", "BusinessPropertyFormPlugin_102", "ebg-aqap-formplugin");
                appInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{name, value, newValue});
            }
        } else {
            MultiLangEnumBridge descBridge = new MultiLangEnumBridge("%1$s\uff1a\u65b0\u589e[%2$s]\u3002", "BusinessPropertyFormPlugin_112", "ebg-aqap-formplugin");
            appInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{name, newValue});
        }
        return appInfo;
    }

    void delete(String objectId, String objectName) {
        QFilter[] qFilters = new QFilter[]{new QFilter("object_id", "=", (Object)objectId), new QFilter("object_name", "=", (Object)objectName)};
        DeleteServiceHelper.delete((String)ENTITY_KEY_OBJECT_PROPERTIES, (QFilter[])qFilters);
    }

    OperationResult save(PropertyConfigItemInfo configItemInfo, String objectId, String objectName, String value, String customID) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        if (ConfigInputType.PASSWORD.getInputType().equals(configItemInfo.getInputType()) && this.getView().getPageCache().get(cacheKeyPre + configItemInfo.getKey()) != null && Objects.equals(specialCode, value)) {
            value = this.getView().getPageCache().get(cacheKeyPre + configItemInfo.getKey());
        }
        dataEntity.set("attr_key", (Object)configItemInfo.getKey());
        dataEntity.set("attr_value", (Object)value);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)customID);
        OperationResult result = SaveServiceHelper.saveOperate((String)ENTITY_KEY_OBJECT_PROPERTIES, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        return result;
    }

    DynamicObject getDataEntity(PropertyConfigItemInfo configItemInfo, String objectId, String objectName, String value, String customID) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity.set("attr_key", (Object)configItemInfo.getKey());
        dataEntity.set("attr_value", (Object)value);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)customID);
        return dataEntity;
    }

    boolean save(DynamicObject[] dataEntities) {
        try {
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
        catch (Throwable t) {
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "BusinessPropertyFormPlugin_12", "ebg-aqap-formplugin");
            MultiLangEnumBridge descBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", "BusinessPropertyFormPlugin_13", "ebg-aqap-formplugin");
            OperationLogUtil.recordInvoke((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{t.toString()});
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }
}

