/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.util;

import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigItemInfo;
import kd.ebg.aqap.formplugin.util.FieldType;
import kd.ebg.aqap.formplugin.util.FieldUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class ControlUtil {
    public static TextProp buildTextPorp(String key, String name) {
        TextProp textProp = new TextProp();
        textProp.setName(key);
        textProp.setDisplayName(new LocaleString(name));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    public static FlexPanelAp createFlexPanelAp(String type) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(type);
        flex.setCollapsible(true);
        flex.setName(new LocaleString(ControlUtil.getFlexPanelApName(type)));
        flex.setGrow(1);
        flex.setShrink(0);
        Style style = new Style();
        Border border = new Border();
        border.setTop("10px #E2E7EF solid");
        style.setBorder(border);
        flex.setStyle(style);
        return flex;
    }

    static String getFlexPanelApName(String type) {
        switch (type) {
            case "default": {
                return ResManager.loadKDString((String)"\u57fa\u7840\u53c2\u6570", (String)"BankBusinessConfigFormPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
            }
            case "container_fjsx": {
                return ResManager.loadKDString((String)"\u9644\u52a0\u5c5e\u6027", (String)"BankAcntFormPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
            }
        }
        return BankPropertyConfigType.getDescByName((String)type);
    }

    public static void addFieldsetPanelApItems(FlexPanelAp flex, List<PropertyConfigItemInfo> propertyConfigItemInfos) {
        propertyConfigItemInfos.stream().forEach(p -> {
            FieldAp fieldAp;
            String name = FieldUtil.getName(p.getMlName(), p.getName());
            String desc = FieldUtil.getDesc(p.getMlDesc(), p.getDesc());
            List<String> sourceNames = FieldUtil.getSourceNames(p.getMlSourceNames(), p.getSourceNames());
            if (ConfigInputType.MUL_SELECT.getInputType().equalsIgnoreCase(p.getInputType())) {
                List<String> sourceVlues = p.getSourceValues();
                fieldAp = FieldUtil.createMulComboField(name, p.getKey(), p.isReadonly(), p.isMustInput(), desc, sourceVlues, sourceNames);
            } else if (CollectionUtil.isNotEmpty(sourceNames) || ConfigInputType.SELECT.getInputType().equalsIgnoreCase(p.getInputType())) {
                fieldAp = FieldUtil.createComboField(name, p.getKey(), p.isReadonly(), p.isHide(), p.isMustInput(), desc, p.getSourceValues(), sourceNames);
            } else if (ConfigInputType.INTEGER.getInputType().equals(p.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, p.getKey(), p.isMustInput(), p.isReadonly(), FieldType.INTEGER, desc);
                FieldUtil.setIntegerFieldApDataScope(fieldAp, p.getMinValueNum(), p.getMaxValueNum());
            } else if (ConfigInputType.DATE.getInputType().equalsIgnoreCase(p.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, p.getKey(), p.isMustInput(), p.isReadonly(), FieldType.DATE, desc);
            } else if (ConfigInputType.TEXTAREA.getInputType().equalsIgnoreCase(p.getInputType())) {
                fieldAp = FieldUtil.createMultiTextField(name, p.getKey(), p.getMaxValueNum());
                FieldUtil.setFieldApReadOnly(fieldAp, p.isReadonly());
                FieldUtil.setFieldApTips(fieldAp, desc);
            } else if (ConfigInputType.CLICK_TEXT.getInputType().equalsIgnoreCase(p.getInputType())) {
                fieldAp = FieldUtil.createClickTextField(name, p.getKey());
                FieldUtil.setFieldApReadOnly(fieldAp, p.isReadonly());
                FieldUtil.setFieldApMustInput(fieldAp, p.isMustInput());
                FieldUtil.setFieldApTips(fieldAp, desc);
            } else {
                fieldAp = FieldUtil.createTextField(name, p.getKey(), p.isMustInput(), p.isReadonly(), "", false);
                FieldUtil.setFieldApReadOnly(fieldAp, p.isReadonly());
                FieldUtil.setFieldApTips(fieldAp, desc);
            }
            if (BankPropertyConfig.isReadOnlyWhenBillEdit((String)fieldAp.getKey())) {
                fieldAp.setLock("edit,view,submit,audit");
            }
            flex.getItems().add(fieldAp);
            if (BankPropertyConfigType.UPLOAD_PARAM.getName().equals(p.getType())) {
                ButtonAp buttonAp = FieldUtil.createButtonAp(p.getKey());
                flex.getItems().add(buttonAp);
            }
        });
    }

    public static void showUploadPage(String pageCaption, String fieldKey, boolean isUpload, IFormPlugin plugin, IFormView view, String bankVersion) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("aqap_cert_parse");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (!isUpload) {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("type", (Object)CertType.BANKLOGIN_CER.getType());
        }
        showParameter.setCustomParam("bankVersionID", (Object)bankVersion);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCaption(pageCaption);
        showParameter.setCustomParam("fieldKey", (Object)fieldKey);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, fieldKey));
        view.showForm(showParameter);
    }

    public static String getUploadName(String str, String key) {
        String[] arr;
        if (StringUtil.isNil(str)) {
            return "";
        }
        for (String s : arr = str.split(",")) {
            String[] k = s.split("-");
            if (!k[0].equalsIgnoreCase(key)) continue;
            return k[1];
        }
        return "";
    }
}

