/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.CollectionUtils;
import kd.ebg.aqap.formplugin.util.ConfigProperty;
import kd.ebg.aqap.formplugin.util.FieldType;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class FieldUtil {
    public static String getDesc(List<MultiLangEnumBridge> mlDesc, String desc) {
        if (CollectionUtils.isEmpty(mlDesc)) {
            return desc;
        }
        StringBuilder builder = new StringBuilder();
        int size = mlDesc.size();
        for (int i = 0; i < size; ++i) {
            MultiLangEnumBridge ml = mlDesc.get(i);
            builder.append(ml.loadKDString());
            if (i == size - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public static List<String> getSourceNames(List<MultiLangEnumBridge> mlSourceNames, List<String> sourceNames) {
        if (CollectionUtils.isEmpty(mlSourceNames)) {
            return sourceNames;
        }
        ArrayList<String> result = new ArrayList<String>(16);
        for (MultiLangEnumBridge ml : mlSourceNames) {
            result.add(ml.loadKDString());
        }
        return result;
    }

    public static String getName(MultiLangEnumBridge mlName, String name) {
        return mlName == null ? name : mlName.loadKDString();
    }

    public static String getDesc(MultiLangEnumBridge mlDesc, String desc) {
        return mlDesc == null ? desc : mlDesc.loadKDString();
    }

    public static String getDesc(MultiLangEnumBridge mlDesc, List<MultiLangEnumBridge> mlDescs, String desc) {
        if (CollectionUtils.isEmpty(mlDescs)) {
            return mlDesc == null ? desc : mlDesc.loadKDString();
        }
        StringBuilder builder = new StringBuilder();
        int size = mlDescs.size();
        for (int i = 0; i < size; ++i) {
            MultiLangEnumBridge ml = mlDescs.get(i);
            builder.append(ml.loadKDString());
            if (i == size - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public static FieldAp createField(String name, String key) {
        return FieldUtil.createDynamicFieldBase(name, key, false, false, FieldType.TEXT, "");
    }

    public static FieldAp createDynamicFieldBase(String name, String key, boolean mustInput, boolean readOnly, FieldType fieldType, String desc) {
        TextField field;
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        if (fieldType == FieldType.TEXT) {
            field = new TextField();
            field.setMaxLength(255);
            fieldAp.setField((Field)field);
        } else if (fieldType == FieldType.INTEGER) {
            field = new IntegerField();
            fieldAp.setField((Field)field);
            fieldAp.setMask("#");
            field.setZeroShow(true);
        } else if (fieldType == FieldType.SWITCH) {
            field = new CheckBoxField();
            field.setShowStyle(0);
            fieldAp.setField((Field)field);
        } else if (fieldType == FieldType.UPLOAD) {
            field = new AttachmentField();
            fieldAp.setField((Field)field);
        } else if (fieldType == FieldType.DATE) {
            field = new DateField();
            fieldAp.setField((Field)field);
            fieldAp.setDisplayFormatString("yyyy-MM-dd");
        } else if (fieldType == FieldType.DATE8) {
            field = new DateField();
            fieldAp.setField((Field)field);
            fieldAp.setDisplayFormatString("yyyyMMdd");
        } else if (fieldType == FieldType.TEXTAREA) {
            TextAreaField textAreaField = new TextAreaField();
            fieldAp.setField((Field)textAreaField);
        } else if (fieldType == FieldType.BASEDATA) {
            BasedataField basedataField = new BasedataField();
            basedataField.setBaseEntityId("aqap_white_list");
            basedataField.setBaseEntityNumber("aqap_white_list");
            basedataField.setDisplayProp("number");
            basedataField.setBizBasedata(false);
            basedataField.setViewDetail(false);
            fieldAp.setField((Field)basedataField);
        } else if (fieldType == FieldType.LARGETEXT) {
            LargeTextField largeTextField = new LargeTextField();
            fieldAp.setField((Field)largeTextField);
        }
        if (readOnly) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
        if (StringUtils.isNotEmpty(desc)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"FieldUtil_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
            tips.setContent(new LocaleString(desc));
            tips.setLink(false);
            fieldAp.setCtlTips(tips);
        }
        fieldAp.getField().setId(key);
        fieldAp.getField().setKey(key);
        fieldAp.getField().setMustInput(mustInput);
        return fieldAp;
    }

    public static FieldAp createDynamicFieldBase(String name, String key, boolean mustInput, boolean readOnly, FieldType fieldType, String desc, Boolean isHidden) {
        TextField field;
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        if (fieldType == FieldType.TEXT) {
            field = new TextField();
            field.setMaxLength(255);
            fieldAp.setField((Field)field);
        } else if (fieldType == FieldType.INTEGER) {
            field = new IntegerField();
            fieldAp.setField((Field)field);
            fieldAp.setMask("#");
            field.setZeroShow(true);
        } else if (fieldType == FieldType.UPLOAD) {
            field = new AttachmentField();
            fieldAp.setField((Field)field);
        } else if (fieldType == FieldType.TEXTAREA) {
            TextAreaField textAreaField = new TextAreaField();
            fieldAp.setField((Field)textAreaField);
        }
        if (readOnly) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
        if (isHidden != null && isHidden.booleanValue()) {
            fieldAp.setHidden(true);
        }
        if (StringUtils.isNotEmpty(desc)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"FieldUtil_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
            tips.setContent(new LocaleString(desc));
            tips.setLink(false);
            fieldAp.setCtlTips(tips);
        }
        fieldAp.getField().setId(key);
        fieldAp.getField().setKey(key);
        fieldAp.getField().setMustInput(mustInput);
        return fieldAp;
    }

    public static void setFieldApReadOnly(FieldAp fieldAp, boolean readOnly) {
        if (readOnly) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
    }

    public static void setFieldApMustInput(FieldAp fieldAp, boolean mustInput) {
        fieldAp.getField().setMustInput(mustInput);
    }

    public static void setFieldApTips(FieldAp fieldAp, String desc) {
        if (StringUtils.isNotEmpty(desc)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"FieldUtil_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
            tips.setContent(new LocaleString(desc));
            tips.setLink(false);
            fieldAp.setCtlTips(tips);
        }
    }

    public static void setFieldApMaxLength(TextField textField, Integer maxLength) {
        if (maxLength != null) {
            textField.setMaxLength(maxLength.intValue());
        }
    }

    public static void setIntegerFieldApDataScope(FieldAp fieldAp, Integer minValue, Integer maxValue) {
        IntegerField integerField = (IntegerField)fieldAp.getField();
        int min = minValue == null ? 0 : minValue;
        int max = maxValue == null ? 0x7FFFFFFE : maxValue;
        integerField.setDataScope("[" + min + "," + max + "]");
    }

    public static FieldAp createDynamicFieldBase(String name, String key, boolean readOnly, String desc) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        if (readOnly) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
        if (StringUtils.isNotEmpty(desc)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"FieldUtil_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
            tips.setContent(new LocaleString(desc));
            tips.setLink(false);
            fieldAp.setCtlTips(tips);
        }
        return fieldAp;
    }

    public static FieldAp createTextField(String name, String key) {
        return FieldUtil.createTextField(name, key, false, false, "", false);
    }

    public static FieldAp createMultiTextField(String name, String key) {
        return FieldUtil.createMultiTextField(name, key, false, false, "", false);
    }

    public static FieldAp createMultiTextField(String name, String key, int maxLength) {
        return FieldUtil.createMultiTextField(name, key, false, false, "", false, maxLength);
    }

    public static FieldAp createLargeTextField(String name, String key, int maxLength) {
        return FieldUtil.createLargeTextField(name, key, false, false, "", maxLength);
    }

    public static FieldAp createAttachmentField(String name, String key, int maxAtmCount, String extendName, String tableName) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, false, false, FieldType.UPLOAD, "");
        AttachmentField field = (AttachmentField)fieldAp.getField();
        field.setMaxAtmCount(maxAtmCount);
        if (StringUtil.isNotNil(extendName)) {
            field.setExtendName(extendName);
        }
        if (StringUtil.isNotNil(tableName)) {
            field.setTableName(tableName);
        }
        return fieldAp;
    }

    public static FieldAp createBasedataField(String name, String key, boolean mustInput, boolean readOnly, String defValue, boolean isPassword) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.BASEDATA, "");
        BasedataField field = (BasedataField)fieldAp.getField();
        return fieldAp;
    }

    public static FieldAp createTextField(String name, String key, boolean mustInput, boolean readOnly, String defValue, boolean isPassword) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.TEXT, "");
        TextField field = (TextField)fieldAp.getField();
        field.setPassword(isPassword);
        return fieldAp;
    }

    public static FieldAp createTextField(String name, String key, boolean mustInput, boolean readOnly, String defValue, boolean isPassword, boolean isClickText) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.TEXT, "");
        TextField field = (TextField)fieldAp.getField();
        field.setPassword(isPassword);
        if (isClickText) {
            field.setEditStyle(1);
        }
        return fieldAp;
    }

    public static FieldAp createMultiTextField(String name, String key, boolean mustInput, boolean readOnly, String defValue, boolean isPassword) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.TEXTAREA, "");
        TextField field = (TextField)fieldAp.getField();
        field.setPassword(isPassword);
        return fieldAp;
    }

    public static FieldAp createMultiTextField(String name, String key, boolean mustInput, boolean readOnly, String defValue, boolean isPassword, int maxLength) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.TEXTAREA, "");
        TextField field = (TextField)fieldAp.getField();
        field.setPassword(isPassword);
        if (maxLength > 0) {
            field.setMaxLength(maxLength);
        }
        fieldAp.setHeight(new LocaleString("48px"));
        return fieldAp;
    }

    public static FieldAp createLargeTextField(String name, String key, boolean mustInput, boolean readOnly, String defValue, int maxLength) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.LARGETEXT, "");
        TextField field = (TextField)fieldAp.getField();
        field.setMaxLength(512);
        fieldAp.setHeight(new LocaleString("48px"));
        return fieldAp;
    }

    public static FieldAp createTextField(ConfigProperty configProperty) {
        configProperty.getPassword();
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(configProperty);
        TextField field = (TextField)fieldAp.getField();
        field.setPassword(configProperty.getPassword().booleanValue());
        return fieldAp;
    }

    public static FieldAp createMultiTextField(ConfigProperty configProperty) {
        FieldAp fieldAp = FieldUtil.createDynamicMultiFieldBase(configProperty);
        TextField field = (TextField)fieldAp.getField();
        field.setPassword(configProperty.getPassword().booleanValue());
        return fieldAp;
    }

    private static FieldAp createDynamicFieldBase(ConfigProperty configProperty) {
        String key = configProperty.getKey();
        String name = configProperty.getName();
        Boolean mustInput = configProperty.getMustInput();
        Boolean readOnly = configProperty.getReadOnly();
        Boolean hidden = configProperty.getHidden();
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.TEXT, "", hidden);
        return fieldAp;
    }

    private static FieldAp createDynamicMultiFieldBase(ConfigProperty configProperty) {
        String name = configProperty.getName();
        String key = configProperty.getKey();
        Boolean mustInput = configProperty.getMustInput();
        Boolean readOnly = configProperty.getReadOnly();
        Boolean hidden = configProperty.getHidden();
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.TEXTAREA, "", hidden);
        return fieldAp;
    }

    public static FieldAp createIntegerField(String name, String key) {
        return FieldUtil.createIntegerField(name, key, false, false, null, "#");
    }

    public static FieldAp createIntegerField(String name, String key, boolean mustInput, boolean readOnly, BigDecimal defValue, String mask) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.INTEGER, "");
        fieldAp.setMask(mask);
        return fieldAp;
    }

    public static FieldAp createComboField(String name, String key, boolean readOnly, boolean mustInput, String desc, List<String> comboKey, List<String> comboValue) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, readOnly, desc);
        ComboField field = new ComboField();
        field.setId(key);
        field.setKey(key);
        field.setMustInput(mustInput);
        fieldAp.setField((Field)field);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (int i = 0; i < comboKey.size(); ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setSeq(i);
            comboItem.setCaption(new LocaleString(comboValue.get(i)));
            comboItem.setValue(comboKey.get(i));
            items.add(comboItem);
        }
        field.setItems(items);
        return fieldAp;
    }

    public static FieldAp createMulComboField(String name, String key, boolean readOnly, boolean mustInput, String desc, List<String> comboKey, List<String> comboValue) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, readOnly, desc);
        MulComboField field = new MulComboField();
        field.setId(key);
        field.setKey(key);
        field.setMustInput(mustInput);
        fieldAp.setField((Field)field);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (int i = 0; i < comboKey.size(); ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setSeq(i);
            comboItem.setCaption(new LocaleString(comboValue.get(i)));
            comboItem.setValue(comboKey.get(i));
            items.add(comboItem);
        }
        field.setItems(items);
        return fieldAp;
    }

    public static FieldAp createComboField(String name, String key, boolean readOnly, boolean isHide, boolean mustInput, String desc, List<String> comboKey, List<String> comboValue) {
        FieldAp fieldAp = FieldUtil.createComboField(name, key, readOnly, mustInput, desc, comboKey, comboValue);
        if (isHide) {
            fieldAp.setVisible("");
        }
        return fieldAp;
    }

    public static ButtonAp createButtonAp(String key) {
        ButtonAp buttonAp = new ButtonAp();
        buttonAp.setKey("btn_" + key);
        buttonAp.setName(new LocaleString(ResManager.loadKDString((String)"\u70b9\u51fb\u4e0a\u4f20", (String)"FieldUtil_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
        buttonAp.setWidth(new LocaleString("100px"));
        buttonAp.setFollowTheme(true);
        buttonAp.setOperationKey("upload");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("20px");
        margin.setLeft("-20px");
        style.setMargin(margin);
        buttonAp.setStyle(style);
        buttonAp.setVisible("new,edit");
        return buttonAp;
    }

    public static FieldAp createClickTextField(String name, String key) {
        return FieldUtil.createTextField(name, key, false, false, "", false, true);
    }
}

