/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opa.service.balance;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opa.util.Packer;
import kd.ebg.aqap.banks.gdb.opa.util.Parser;
import kd.ebg.aqap.banks.gdb.opa.util.SendUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = SendUtil.send(this.getBizCode(), rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Header", (Object)Packer.createHeader());
        JSONObject body = new JSONObject();
        jsonObject.put("Body", (Object)body);
        body.put("account", (Object)((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)).getAccNo());
        body.put("ccyType", (Object)bankBalanceRequest.getBankCurrency());
        return jsonObject.toString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        Parser.parseHeader(jsonObject.getJSONObject("Header"), this.getBizDesc());
        JSONObject body = jsonObject.getJSONObject("Body");
        String sysRetCode = body.getString("bizRetCode");
        String sysRetInfo = body.getString("bizRetInfo");
        if (!"000000".equals(sysRetCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21%1$s\u4e1a\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u8fd4\u56de\u7801:%2$s,\u5f02\u5e38\u4fe1\u606f\uff1a%3$s", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), this.getBizDesc(), sysRetCode, sysRetInfo);
            logger.info(errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        BalanceInfo info = new BalanceInfo();
        balances.add(info);
        String account = body.getString("account");
        String balance = body.getString("balance");
        String usableBal = body.getString("usableBal");
        String ccyType = body.getString("ccyType");
        info.setCurrentBalance(new BigDecimal(balance));
        info.setAvailableBalance(new BigDecimal(usableBal));
        info.setBankCurrency(ccyType);
        info.setBankAcnt(bankBalanceRequest.getAcnt());
        info.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "acctBalanceQuery";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]);
    }
}

