/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.dc.service.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.dc.Packer;
import kd.ebg.aqap.banks.xmb.dc.Parser;
import kd.ebg.aqap.banks.xmb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBBaseException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=GBK");
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u8d75\u4fca\u5cf0", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "CBE004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest rqst) {
        Element XCCBEBankData = new Element("XCCBEBankData");
        Element opReq = JDomUtils.addChild((Element)XCCBEBankData, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)EBContext.getContext().getBankRequestSeq());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"SHMU", (String)"1");
        Element list = JDomUtils.addChild((Element)ReqParam, (String)"list");
        Element row = JDomUtils.addChild((Element)list, (String)"row");
        JDomUtils.addChild((Element)row, (String)"ZHHA", (String)rqst.getAcnt().getAccNo());
        String xmlMessage = Packer.packFormatXmlMsg(XCCBEBankData, "GBK");
        String sessionId = LoginAndOut.getLoginAndOut().getLoginSessionId();
        return Packer.packAll(sessionId, "CBE004", xmlMessage);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        BankResponse response = Parser.parserMsgHead(rspStr);
        if (!"0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element root = Parser.getXmlRoot(rspStr);
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        Element list = opResult.getChild("list");
        List rows = list.getChildren("row");
        if (null == rows || 0 == rows.size()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%s)\u4f59\u989d\u5931\u8d25,\u94f6\u884c\u672a\u8fd4\u56de\u8be5\u8d26\u53f7\u7684\u4f59\u989d\u4fe1\u606f.", (String)"BalanceImpl_11", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), rqst.getAcnt().getAccNo()));
        }
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String ZHHA = row.getChildTextTrim("ZHHA");
            if (rqst.getAcnt().getAccNo().equalsIgnoreCase(ZHHA)) {
                String YUER = row.getChildTextTrim("YUER");
                String KYER = row.getChildTextTrim("KYER");
                String BIZH = row.getChildTextTrim("BIZH");
                BalanceInfo balance = new BalanceInfo();
                balance.setBankAcnt(rqst.getAcnt());
                balance.setBalanceDateTime(LocalDateTime.now());
                balance.setBankCurrency(BIZH);
                this.setCurrentBalance(balance, YUER);
                this.setAvailableBalance(balance, KYER);
                EBBankBalanceResponse rsp = new EBBankBalanceResponse();
                rsp.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
                return rsp;
            }
            logger.info("\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u8d26\u53f7:" + ZHHA);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%s)\u4f59\u989d\u5931\u8d25,\u94f6\u884c\u672a\u8fd4\u56de\u8be5\u8d26\u53f7\u7684\u4f59\u989d\u4fe1\u606f.", (String)"BalanceImpl_11", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), rqst.getAcnt().getAccNo()));
    }

    private BigDecimal convert(String amt, String tips) throws EBBaseException {
        try {
            return BigDecimalHelper.add((String)"0.00", (String)amt);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8f6c\u6362%1$s\u51fa\u9519\uff0c\u5f85\u8f6c\u6362\u7684\u503c\u4e3a:%2$s\u3002", (String)"BalanceImpl_12", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), tips, amt), (Throwable)e);
        }
    }
}

