/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hfb.dc.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class FileUtils {
    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtils.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw EBExceiptionUtil.serviceException((String)message);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw EBExceiptionUtil.serviceException((String)message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw EBExceiptionUtil.serviceException((String)message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                FileUtils.delete(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean isDeleted;
            boolean filePresent = file.exists();
            if (filePresent && !(isDeleted = file.delete())) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static String getFilePathFromRoot(String fileName) throws EBServiceException {
        String bootdir = FileCommonUtils.checkPath((String)System.getProperty("osgi.install.area"));
        if (bootdir == null) {
            bootdir = "";
        }
        try {
            return new URI(bootdir + fileName).getPath();
        }
        catch (URISyntaxException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u8def\u5f84\u5931\u8d25%s\u3002", (String)"FileUtils_1", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]), fileName), (Throwable)e);
        }
    }

    public static void mkdirs(String absolutePath) {
        File f = FileCommonUtils.getFileByPath((String)absolutePath);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static String getMBTSFilePath() throws EBServiceException {
        String path = "files/mbts/";
        String absolutePath = FileUtils.getFilePathFromRoot(path);
        FileUtils.mkdirs(absolutePath);
        return absolutePath;
    }

    public static File getFileFromMBTSFilePath(String fileName) throws EBServiceException {
        String filePath = FileUtils.getMBTSFilePath() + fileName;
        return FileCommonUtils.getFileByPath((String)filePath);
    }
}

