/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.oversea;

import java.io.InputStream;
import java.io.OutputStream;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryOrgIdHelper
extends AbstractImpl {
    public String getOrgId() {
        String rqstStr = this.pack();
        String rspStr = "";
        try {
            ConnectionFactory factory = this.getConnectionFactory();
            factory.setUri("/online/FOX4Securities");
            IConnection connection = this.getConnection(factory);
            this.openConnection(connection);
            try (OutputStream os = this.getOutputStream(connection);){
                this.send(os, rqstStr);
                try (InputStream is = this.getInputStream(connection);){
                    rspStr = this.recv(is);
                    this.closeOutputStreamQuietly(os);
                    this.closeInputStreamQuietly(is);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return this.parse(rspStr);
    }

    private String parse(String rspStr) {
        Element content;
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element outremitorgquerytrnrs = eb1.getChild("OUTREMITORGQUERYTRNRS");
        Element rsbody = JDomUtils.getChildElement((Element)outremitorgquerytrnrs, (String)"RSBODY");
        if (rsbody != null && (content = JDomUtils.getChildElement((Element)rsbody, (String)"CONTENT")) != null) {
            return JDomUtils.getChildText((Element)content, (String)"ORG_ID");
        }
        return "";
    }

    private String pack() {
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element outremitorgquerytrnrq = JDomUtils.addChild((Element)msgsv, (String)"OUTREMITORGQUERYTRNRQ");
        JDomUtils.addChild((Element)outremitorgquerytrnrq, (String)"TRNUID", (String)Sequence.genSequence());
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }
}

