/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.oversea;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryOverseaPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/online/FOX4Securities");
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element outwardremitquerytrnrq = JDomUtils.addChild((Element)msgsv, (String)"OUTWARDREMITQUERYTRNRQ");
        JDomUtils.addChild((Element)outwardremitquerytrnrq, (String)"TRNUID", (String)Sequence.genSequence());
        Element rqbody = JDomUtils.addChildAttribute((Element)outwardremitquerytrnrq, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)rqbody, (String)"REMIT_TYPE", (String)"1");
        JDomUtils.addChild((Element)rqbody, (String)"CLT_REF_NO", (String)paymentInfo.getBankDetailSeqID());
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element outwardremitquerytrnrs = JDomUtils.getChildElement((Element)eb1, (String)"OUTWARDREMITQUERYTRNRS");
        Element status = outwardremitquerytrnrs.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        if ("0".equalsIgnoreCase(code)) {
            Element rsbody = outwardremitquerytrnrs.getChild("RSBODY");
            if (rsbody != null) {
                List content = rsbody.getChildren("CONTENT");
                Element element = (Element)content.get(0);
                String clt_ref_no = JDomUtils.getChildText((Element)element, (String)"CLT_REF_NO");
                String remit_status = JDomUtils.getChildText((Element)element, (String)"REMIT_STATUS");
                String reason = JDomUtils.getChildText((Element)element, (String)"REASON");
                PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)clt_ref_no);
                if (paymentInfo != null) {
                    if ("01".equalsIgnoreCase(remit_status)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)remit_status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryOverseaPayImpl_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
                    } else if ("02".equalsIgnoreCase(remit_status)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)remit_status, (String)reason);
                    } else if ("03".equalsIgnoreCase(remit_status)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)remit_status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryOverseaPayImpl_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
                    } else {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)remit_status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryOverseaPayImpl_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
                    }
                }
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)message);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "OUTWARDREMITQUERYTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u672c\u884c\u8de8\u5883\u6c47\u51fa\u6c47\u6b3e\u67e5\u8be2", (String)"QueryOverseaPayImpl_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
    }
}

