/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.utils;

import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;

public class FileContentWriterUtil {
    public static void writeFileContent(String filePath, byte[] data) {
        FileContentWriterUtil.writeFileContent(filePath, data, false);
    }

    public static void writeFileContent(String filePath, byte[] data, boolean append) {
        FileContentWriterUtil.writeFileContent(filePath, data, 0, data.length, append);
    }

    public static void writeFileContent(String filePath, String content, String encoding) {
        FileContentWriterUtil.writeFileContent(filePath, content, encoding, false);
    }

    public static void writeFileContent(String filePath, String content, String encoding, boolean append) {
        try {
            FileContentWriterUtil.writeFileContent(filePath, content.getBytes(encoding), append);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void writeGBKFileContent(String filePath, String content) {
        FileContentWriterUtil.writeFileContent(filePath, content, "GBK");
    }

    public static void writeUTF8FileContent(String filePath, String content) {
        FileContentWriterUtil.writeFileContent(filePath, content, "UTF-8");
    }

    public static void writeFileContent(String filePath, byte[] data, int offset, int length, boolean append) {
        try (FileOutputStream fos = new FileOutputStream(filePath, append);){
            fos.write(data, offset, length);
            fos.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

