/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.swift.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import kd.ebg.aqap.proxy.swift.exception.SwiftException;
import kd.ebg.aqap.proxy.swift.model.SwiftMessage;

public class SwiftParser {
    private String data;
    private char blockStart = (char)123;
    private char blockEnd = (char)125;
    private SwiftMessage message = new SwiftMessage();
    private File swiftFile;

    public SwiftParser() {
    }

    public SwiftParser(File swiftFile) {
        this.swiftFile = swiftFile;
        this.data = this.readSwiftFile(swiftFile);
    }

    public File getSwiftFile() {
        return this.swiftFile;
    }

    public void setSwiftFile(File swiftFile) {
        this.swiftFile = swiftFile;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    private String readSwiftFile(File swiftFile) {
        if (swiftFile == null) {
            throw new SwiftException("SwiftFile is null.");
        }
        StringBuilder buffer = new StringBuilder();
        try (FileReader fileReader = new FileReader(swiftFile);
             BufferedReader reader = new BufferedReader(fileReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append("\n");
            }
        }
        catch (Exception e) {
            throw new SwiftException("Read SwiftFile Exception :" + e.getMessage(), e);
        }
        return buffer.toString();
    }

    public SwiftMessage parseMessage() {
        if (this.data == null) {
            throw new SwiftException("Swift data is null.");
        }
        int dataLength = this.data.length();
        StringBuffer buffer = new StringBuffer();
        String blockType = "";
        String basicBlockType = "";
        int blockCount = 0;
        for (int index = 0; index < dataLength; ++index) {
            char currChar = this.data.charAt(index);
            buffer.append(currChar);
            if (currChar == this.blockStart) {
                blockType = this.data.substring(index + 1, this.data.indexOf(":", index) + 1);
                if (this.isBasicBlock(blockType)) {
                    basicBlockType = blockType;
                    continue;
                }
                ++blockCount;
                continue;
            }
            if (currChar != this.blockEnd) continue;
            if (blockCount != 0) {
                --blockCount;
                continue;
            }
            this.createBasicBlock(basicBlockType, buffer);
            buffer = new StringBuffer();
        }
        this.message.getSwiftBasicHeaderBlock().parserText();
        this.message.getSwiftApplicationHeaderBlock().parserText();
        this.message.getSwiftUserHeaderBlock().parserText();
        this.message.getSwiftTextBlock().parserText();
        this.message.getSwiftTrailBlock().parserText();
        return this.message;
    }

    private boolean isBasicBlock(String blockType) {
        return blockType.equals("1:") || blockType.equals("2:") || blockType.equals("3:") || blockType.equals("4:") || blockType.equals("5:");
    }

    private void createBasicBlock(String basicBlockType, StringBuffer buffer) {
        if (basicBlockType.equals("1:")) {
            this.message.getSwiftBasicHeaderBlock().setUnParserText(buffer.toString());
        } else if (basicBlockType.equals("2:")) {
            this.message.getSwiftApplicationHeaderBlock().setUnParserText(buffer.toString());
        } else if (basicBlockType.equals("3:")) {
            this.message.getSwiftUserHeaderBlock().setUnParserText(buffer.toString());
        } else if (basicBlockType.equals("4:")) {
            this.message.getSwiftTextBlock().setUnParserText(buffer.toString());
        } else if (basicBlockType.equals("5:")) {
            this.message.getSwiftTrailBlock().setUnParserText(buffer.toString());
        }
    }
}

