/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.log.EBGLogger;

public class BankBusinessConfig
extends BankPropertyConfig {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankBusinessConfig.class);
    public static final PropertyConfigItem HSBL_DBRT_ID = PropertyConfigItem.builder().key("hsbl_dbrt_id").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u5408\u540c\u7f16\u53f7", "BankBusinessConfig_0", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("ACH\u4ed8\u6b3e\u5408\u540c\u7f16\u53f7\uff0c\u591a\u4e2a\u7f16\u53f7\u4f7f\u7528\u9017\u53f7\u5206\u9694\u3002", "BankBusinessConfig_1", "ebg-aqap-banks-hsbl-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBL_DC_BICCODE = PropertyConfigItem.builder().key("HSBL_DC_BICCODE").mlName(new MultiLangEnumBridge("SWIFT CODE", "BankBusinessConfig_2", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("SWIFT Code\uff08\u94f6\u884c\u56fd\u9645\u4ee3\u7801\uff09\uff1a\u8de8\u5883\u652f\u4ed8/\u5883\u5185\u5916\u5e01\u4e1a\u52a1\u4f7f\u7528\uff0c\u901a\u5e38\u75318\u621611\u4f4d\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u6210\u3002", "BankBusinessConfig_50", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u6709\uff1aACH\u3001CHECK\u3001PP\u63a5\u53e3\u3002", "BankBusinessConfig_51", "ebg-aqap-banks-hsbl-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBL_DC_BANKNAME = PropertyConfigItem.builder().key("HSBL_DC_BANKNAME").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u540d\u79f0", "BankBusinessConfig_3", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u540d\u79f0", "BankBusinessConfig_3", "ebg-aqap-banks-hsbl-dc")})).isAccNo(true).defaultValues((List)Lists.newArrayList((Object[])new String[]{"THE HONGKONG AND SHANGHAI BANKING CORPORATION LTD"})).build();
    public static final PropertyConfigItem HSBL_DC_BANKCITY = PropertyConfigItem.builder().key("HSBL_DC_BANKCITY").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u57ce\u5e02", "BankBusinessConfig_4", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u57ce\u5e02", "BankBusinessConfig_4", "ebg-aqap-banks-hsbl-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBL_DC_PAY_COMPANY_ACNT = PropertyConfigItem.builder().key("HSBL_DC_PAY_COMPANY_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_5", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_5", "ebg-aqap-banks-hsbl-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBL_DC_PAY_COMPANY_STREET_ACNT = PropertyConfigItem.builder().key("HSBL_DC_PAY_COMPANY_STREET_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_6", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_6", "ebg-aqap-banks-hsbl-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBL_DC_ACNT_NAME = PropertyConfigItem.builder().key("HSBL_DC_ACNT_NAME").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u8d26\u6237\u540d", "BankBusinessConfig_7", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u8d26\u6237\u540d\uff08\u82f1\u6587\uff09", "BankBusinessConfig_8", "ebg-aqap-banks-hsbl-dc")})).isAccNo(true).build();
    private static final PropertyConfigItem HSBL_DC_BATCH_NUMBER = PropertyConfigItem.builder().key("HSBL_DC_BATCH_NUMBER").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u6587\u4ef6\u5305\u542b\u7684\u4ed8\u6b3e\u7b14\u6570\u4e0a\u9650\u3002", "BankBusinessConfig_9", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u6279\u91cf\u652f\u4ed8(BATCH_PAY)\u7684\u4ed8\u6b3e\u6587\u4ef6\u4e2d\u53ef\u5305\u542b\u7684\u4ed8\u6b3e\u7b14\u6570\u4e0a\u9650\u3002", "BankBusinessConfig_10", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("\u914d\u7f6e\u8be5\u53c2\u6570\u540e\uff0c\u94f6\u4f01\u4e91\u5c06\u6309\u7167\u914d\u7f6e\u503c\u8bbe\u7f6e\u6279\u6b21\u5927\u5c0f\u3002", "BankBusinessConfig_11", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("\u4e0d\u8bbe\u7f6e\u5219\u9ed8\u8ba4100", "BankBusinessConfig_12", "ebg-aqap-banks-hsbl-dc")})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"100"})).set2Integer().build();
    private static final PropertyConfigItem HSBL_DC_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("HSBL_DC_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4\u3002", "BankBusinessConfig_13", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002", "BankBusinessConfig_38", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_39", "ebg-aqap-banks-hsbl-dc")})).set2Integer().build();
    public static final PropertyConfigItem HSBL_DC_PAY_PROTOCOL = PropertyConfigItem.builder().key("HSBL_DC_PAY_PROTOCOL").mlName(new MultiLangEnumBridge("\u7528\u6237\u4e0e\u94f6\u884c\u7b7e\u8ba2\u7684\u534f\u8bae", "BankBusinessConfig_16", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u7528\u6237\u4f7f\u7528\u7684\u534f\u8bae\uff0c\u5982AUTH", "BankBusinessConfig_17", "ebg-aqap-banks-hsbl-dc")})).build();
    public static final PropertyConfigItem HSBL_DC_BALANCE_MENTHOD = PropertyConfigItem.builder().key("HSBL_DC_BALANCE_MENTHOD").mlName(new MultiLangEnumBridge("\u67e5\u8be2\u4f59\u989d\u65b9\u5f0f", "BankBusinessConfig_18", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u67e5\u8be2\u4f59\u989d\u65b9\u5f0f\uff08\u4fee\u6539\u540e\u9700\u91cd\u542f\u751f\u6548\uff09", "BankBusinessConfig_40", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("1)\u6587\u4ef6\u683c\u5f0f\uff1a\u4f7f\u7528MT940\u6216MT942\u6587\u4ef6\u4ea4\u4e92\uff0c\u94f6\u884c\u63a8\u9001\u6587\u4ef6\u540e\u624d\u6709\u6570\u636e\uff0c\u9ed8\u8ba4\u65b9\u5f0f", "BankBusinessConfig_41", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("2)API\uff1a\u4f7f\u7528API\u63a5\u53e3\uff0c\u5b9e\u65f6\u67e5\u8be2", "BankBusinessConfig_42", "ebg-aqap-banks-hsbl-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u6587\u4ef6\u683c\u5f0f", "BankBusinessConfig_22", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("API\u63a5\u53e3", "BankBusinessConfig_49", "ebg-aqap-banks-hsbl-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"FILE", "API"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"FILE"})).mustInput(true).build();
    public static final PropertyConfigItem HSBL_DC_DETAIL_MENTHOD = PropertyConfigItem.builder().key("HSBL_DC_DETAIL_MENTHOD").mlName(new MultiLangEnumBridge("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u65b9\u5f0f", "BankBusinessConfig_23", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u65b9\u5f0f\uff08\u4fee\u6539\u540e\u9700\u91cd\u542f\u751f\u6548\uff09", "BankBusinessConfig_43", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("1)\u6587\u4ef6\u683c\u5f0f\uff1a\u4f7f\u7528MT940\u6216MT942\u6587\u4ef6\u4ea4\u4e92\uff0c\u94f6\u884c\u63a8\u9001\u6587\u4ef6\u540e\u624d\u6709\u6570\u636e\uff0c\u9ed8\u8ba4\u65b9\u5f0f", "BankBusinessConfig_41", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("2)API\uff1a\u4f7f\u7528API\u63a5\u53e3\uff0c\u5b9e\u65f6\u67e5\u8be2", "BankBusinessConfig_42", "ebg-aqap-banks-hsbl-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u6587\u4ef6\u683c\u5f0f", "BankBusinessConfig_22", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("API\u63a5\u53e3", "BankBusinessConfig_49", "ebg-aqap-banks-hsbl-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"FILE", "API"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"FILE"})).mustInput(true).build();
    public static final PropertyConfigItem HSBL_DC_BORDER_MENTHOD = PropertyConfigItem.builder().key("HSBL_DC_BORDER_MENTHOD").mlName(new MultiLangEnumBridge("\u5883\u5185\u652f\u4ed8\u4e0a\u9001\u65b9\u5f0f", "BankBusinessConfig_25", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5883\u5185\u652f\u4ed8\u6587\u4ef6\u4e0a\u9001\u65b9\u5f0f\u9009\u62e9\uff1a", "BankBusinessConfig_44", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("\u6ce8\uff1axml\u6587\u4ef6\u76ee\u524d\u53ea\u652f\u6301\u4eba\u6c11\u5e01\u4e1a\u52a1\uff0c\u4e0d\u652f\u6301\u5916\u5e01\u3002", "BankBusinessConfig_45", "ebg-aqap-banks-hsbl-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("xml\u6587\u4ef6", "BankBusinessConfig_28", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("iFile\u6587\u4ef6", "BankBusinessConfig_29", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("API\u63a5\u53e3", "BankBusinessConfig_30", "ebg-aqap-banks-hsbl-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"xml", "iFile", "api"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"iFile"})).mustInput(true).build();
    public static final PropertyConfigItem HSBL_DC_DETAIL_NO = PropertyConfigItem.builder().key("HSBL_DC_DETAIL_NO").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u6d41\u6c34\u53f7\u53d6\u503c\u9009\u62e9\u3002", "BankBusinessConfig_31", "ebg-aqap-banks-hsbl-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u6d41\u6c34\u53f7\u662f\u5426\u7531\u94f6\u4f01\u4e91\u5e73\u53f0\u81ea\u52a8\u751f\u6210\uff1a", "BankBusinessConfig_46", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("1)\u662f\uff1a\u7531\u94f6\u4f01\u4e91\u5e73\u53f0\u751f\u6210\u76848\u4f4d\u552f\u4e00\u6d41\u6c34\u53f7\uff0c\u9ed8\u8ba4\u65b9\u5f0f", "BankBusinessConfig_47", "ebg-aqap-banks-hsbl-dc"), new MultiLangEnumBridge("2)\u5426\uff1a\u7531\u661f\u701a\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u7f16\u53f7\uff0c\u4e3b\u8981\u7528\u4e8e\u56de\u5199\u5728\u4ed8\u6b3e\u901a\u77e5\u5355\u4e0a\u7684'\u5ba2\u6237\u53c2\u8003\u7f16\u53f7'", "BankBusinessConfig_48", "ebg-aqap-banks-hsbl-dc")})).mlSourceNames(mlTrueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultTrue).mustInput(true).build();

    public String getBankVersionID() {
        return "HSBL_DC";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List lists = this.getBankAddtionalPropertyConfigItems();
        ArrayList propertyConfigItems = Lists.newArrayList((Object[])new PropertyConfigItem[]{HSBL_DBRT_ID, HSBL_DC_BICCODE, HSBL_DC_BANKNAME, HSBL_DC_BANKCITY, HSBL_DC_PAY_COMPANY_ACNT, HSBL_DC_PAY_COMPANY_STREET_ACNT, HSBL_DC_ACNT_NAME, HSBL_DC_BATCH_NUMBER, HSBL_DC_PAY_STATE_TIMEOUT, HSBL_DC_PAY_PROTOCOL, HSBL_DC_BALANCE_MENTHOD, HSBL_DC_DETAIL_MENTHOD, HSBL_DC_BORDER_MENTHOD, HSBL_DC_DETAIL_NO});
        lists.addAll(propertyConfigItems);
        return lists;
    }

    public String getConfigName() {
        return ResManager.loadKDString((String)"\u6052\u751f\u94f6\u884c\u914d\u7f6e", (String)"BankBusinessConfig_37", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]);
    }

    public String getConfigDesc() {
        return ResManager.loadKDString((String)"\u6052\u751f\u94f6\u884c\u914d\u7f6e", (String)"BankBusinessConfig_37", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]);
    }

    public static String[] getDbtrId(String accNo) {
        String id = HSBL_DBRT_ID.getCurrentValueWithObjectID(accNo);
        return id.split(",");
    }

    public static int getBatchNumber() {
        String config = HSBL_DC_BATCH_NUMBER.getCurrentValue();
        if (null != config && config.length() > 0) {
            try {
                int batchNumber = Integer.parseInt(config);
                return batchNumber;
            }
            catch (NumberFormatException e) {
                return 100;
            }
        }
        return 100;
    }

    public static int getPayStateTimeout() {
        String config = HSBL_DC_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != config && config.length() > 0) {
            try {
                if (Integer.parseInt(config) > 0) {
                    timeout = Integer.parseInt(config);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(Date submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        Date deadlineTime = new Date(submitSuccessTime.getTime() + (long)(payStateTimeout * 60 * 60 * 1000));
        return deadlineTime.before(new Date());
    }

    public static String getPayProtocol() {
        return HSBL_DC_PAY_PROTOCOL.getCurrentValue();
    }

    public static String getBalanceMethod() {
        return HSBL_DC_BALANCE_MENTHOD.getCurrentValue();
    }

    public static String getDetailMethod() {
        return HSBL_DC_DETAIL_MENTHOD.getCurrentValue();
    }

    public static boolean isChooseEBG() {
        return Boolean.parseBoolean(HSBL_DC_DETAIL_NO.getCurrentValue());
    }

    public static String getBicCode(String accNo) {
        return HSBL_DC_BICCODE.getCurrentValueWithObjectID(accNo);
    }

    public static String getBankName(String accNo) {
        return HSBL_DC_BANKNAME.getCurrentValueWithObjectID(accNo);
    }

    public static String getBankCity(String accNo) {
        return HSBL_DC_BANKCITY.getCurrentValueWithObjectID(accNo);
    }

    public static String getBorderPay() {
        return HSBL_DC_BORDER_MENTHOD.getCurrentValue();
    }

    public static String getPayCompanyName(String accNo) {
        return HSBL_DC_PAY_COMPANY_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayStreetName(String accNo) {
        return HSBL_DC_PAY_COMPANY_STREET_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getAcntName(String accNo) {
        return HSBL_DC_ACNT_NAME.getCurrentValueWithObjectID(accNo);
    }

    public boolean isForeignBank() {
        return true;
    }
}

