/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.api.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.api.HsblPgpHelper;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.HSBL_DC_Utils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.HttpsConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger LOGGER = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.getBalanceMethod().equalsIgnoreCase("API");
    }

    public IConnection getConnection(ConnectionFactory factory) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("x-hsbc-client-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientId));
        httpHeaders.put("x-hsbc-client-secret", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientSecret));
        httpHeaders.put("x-hsbc-profile-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.profileId));
        httpHeaders.put("x-report-type", "CAMT52");
        String ip = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiIP);
        String port = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiPort);
        String protocol = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiProtocol);
        String uri = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.balanceURI);
        String timeOut = RequestContextUtils.getBankParameterValue((String)"timeout");
        if ("http".equalsIgnoreCase(protocol)) {
            return new HttpConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        if ("tcp".equalsIgnoreCase(protocol)) {
            return new TcpConnection(ip, Integer.parseInt(port), Integer.parseInt(timeOut));
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return new HttpsConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5176\u4ed6\u901a\u8baf\u534f\u8bae\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
    }

    public String getDeveloper() {
        return "guoqiangyao";
    }

    public String getBizCode() {
        return HsblMetaDataImpl.balanceURI;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6052\u751f\u94f6\u884cAPI\u4f59\u989d\u63a5\u53e3\u3002", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest rqst) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        JSONObject accountBalances = new JSONObject();
        String country = rqst.getAcnt().getCountry();
        LOGGER.info(ResManager.loadKDString((String)"\u8bf7\u6c42\u5230\u7684\u56fd\u5bb6\u540d\u79f0\u4e3a{}\u3002", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (Object)country);
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
        if (null == code) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56fd\u5bb6\u7801\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"BalanceImpl_25", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), country));
        }
        accountBalances.put("accountNumber", (Object)rqst.getAcnt().getAccNo());
        accountBalances.put("accountCountry", (Object)code.geteChart2());
        accountBalances.put("institutionCode", (Object)RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.institutionCode));
        accountBalances.put("accountType", (Object)"CA");
        JSONArray all = new JSONArray();
        all.add((Object)accountBalances);
        JSONObject total = new JSONObject();
        total.put("accountBalances", (Object)all);
        try {
            LOGGER.info(ResManager.loadKDString((String)"\u8bf7\u6c42\u7684total\u4fe1\u606f{}\u3002", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (Object)total.toJSONString());
            String base64 = HsblPgpHelper.encry(total.toJSONString());
            JSONObject request = new JSONObject();
            request.put("balancesRequestBase64", (Object)base64);
            logger.infoFilerLog("\u53d1\u9001\u94f6\u884c:" + request.toJSONString());
            return request.toJSONString();
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"BalanceImpl_26", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element rpt;
        List list;
        String origin;
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        logger.infoFilerLog("\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
        JSONObject accountBalances = JSONObject.parseObject((String)rspStr);
        String statusCode = accountBalances.getString("statusCode");
        String statusDesc = accountBalances.getString("statusDesc");
        if (!"ACCP".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25,%1$s,%2$s", (String)"BalanceImpl_27", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), statusCode, statusDesc));
        }
        String base64 = accountBalances.getString("reportBase64");
        try {
            origin = HsblPgpHelper.decry(base64);
            logger.info("\u89e3\u5bc6\u9a8c\u7b7e\u540e\u7684\u539f\u6587:" + origin);
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"BalanceImpl_28", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        Document document = JDomUtils.str2Doc((String)origin, (String)"UTF-8");
        Element root = document.getRootElement();
        Namespace ns = root.getNamespace();
        Element BkToCstmrStmt = HSBL_DC_Utils.getElementNotNull(root, "BkToCstmrAcctRpt", ns);
        if (BkToCstmrStmt == null) {
            ns = null;
            BkToCstmrStmt = HSBL_DC_Utils.getElementNotNull(root, "BkToCstmrAcctRpt", ns);
        }
        if (null == (list = (rpt = HSBL_DC_Utils.getElementNotNull(BkToCstmrStmt, "Rpt", ns)).getChildren("Bal", ns)) || list.size() < 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 ,Bal\u8282\u70b9\u4e3a\u7a7a", (String)"BalanceImpl_10", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        }
        String balance = null;
        String avaBalance = null;
        String cur = null;
        for (Element bal : list) {
            Element tp = HSBL_DC_Utils.getElementNotNull(bal, "Tp", ns);
            Element CdOrPrtry = HSBL_DC_Utils.getElementNotNull(tp, "CdOrPrtry", ns);
            String cd = HSBL_DC_Utils.getChildText(CdOrPrtry, "Cd", ns);
            if ("ITBD".equalsIgnoreCase(cd)) {
                Element Amt = HSBL_DC_Utils.getElementNotNull(bal, "Amt", ns);
                balance = HSBL_DC_Utils.getChildText(bal, "Amt", ns);
                cur = Amt.getAttributeValue("Ccy");
            }
            if (!"ITAV".equalsIgnoreCase(cd)) continue;
            avaBalance = HSBL_DC_Utils.getChildText(bal, "Amt", ns);
        }
        BalanceInfo info = new BalanceInfo();
        info.setBankCurrency(cur);
        info.setBankAcnt(bankBalanceRequest.getAcnt());
        info.setCurrentBalance(new BigDecimal(balance));
        info.setAvailableBalance(new BigDecimal(avaBalance));
        info.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{info}));
    }
}

