/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.payment.oversea.pp;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.service.HSBL_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = HSBL_DC_Parser.parseHeader(root);
        if ("BIZ_FAIL".equalsIgnoreCase(rsp.getResponseCode()) || !"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() == 0) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String serialNo = JDomUtils.getChildTextTrim((Element)list, (String)"serialNo");
            String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
            Element status = JDomUtils.getChildElement((Element)list, (String)"status");
            String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
            String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)serialNo);
            if (null == info) {
                logger.error("\u672a\u5339\u914d\u5230\u6d41\u6c34\u53f7" + serialNo + "\u7684\u4ed8\u6b3e\u8bb0\u5f55");
                continue;
            }
            if ("BCC_PAY_SUCCESS".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_ID_NOT_EXIST".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_FAIL".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_SUBMT_SUCCESS".equalsIgnoreCase(txStatus)) {
                if (BankBusinessConfig.isPayStateTimeout(Date.from(Instant.from(info.getSubmitSuccessTime())))) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        for (PaymentInfo info : paymentInfos) {
            if (PaymentState.SUBMITED.getId() != info.getStatus().intValue() || !BankBusinessConfig.isPayStateTimeout(Date.from(Instant.from(info.getSubmitSuccessTime())))) continue;
            logger.info("\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u8d85\u65f6\uff0c\u8bbe\u7f6e\u4ed8\u6b3e\u72b6\u6001\u672a\u4ea4\u6613\u672a\u786e\u8ba4");
            info.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
            info.setStatusMsg(ResManager.loadKDString((String)"\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u8d85\u51fa\u9650\u5b9a\u65f6\u95f4\u3002", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        }
    }
}

