/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.payment.oversea.utils;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.ebg.aqap.banks.hsbl.dc.service.payment.oversea.utils.CacheData;

public class CacheManager {
    private static Map<String, CacheData> CACHE_DATA = new ConcurrentHashMap<String, CacheData>();

    public static <T> T getData(String key, Load<T> load, Date expire) {
        T data = CacheManager.getData(key);
        if (data == null && load != null && (data = load.load()) != null) {
            CacheManager.setData(key, data, expire);
        }
        return data;
    }

    public static <T> T getData(String key) {
        CacheData data = CACHE_DATA.get(key);
        if (data != null) {
            return data.getData();
        }
        return null;
    }

    public static <T> void setData(String key, T data, Date expire) {
        CACHE_DATA.put(key, new CacheData<T>(data, expire));
    }

    public static void clear(String key) {
        CACHE_DATA.remove(key);
    }

    public static void clearAll() {
        CACHE_DATA.clear();
    }

    public static void remove(Date date) {
        for (String key : CACHE_DATA.keySet()) {
            int tag;
            CacheData cacheData = (CacheData)CacheManager.getData(key);
            if (cacheData == null || (tag = cacheData.getExpire().compareTo(date)) >= 0) continue;
            CacheManager.clear(key);
        }
    }

    public static interface Load<T> {
        public T load();
    }
}

