/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.simulator.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.banks.simulator.utils.Constants;
import kd.ebg.aqap.banks.simulator.utils.QueryUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class SimBalanceImpl
extends AbstractBalanceImpl
implements IBalance,
IHisBalance {
    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        ArrayList<BalanceInfo> ret = new ArrayList<BalanceInfo>(8);
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        List bankAcntList = request.getBankAcntList();
        while (!startDate.isAfter(endDate)) {
            for (BankAcnt acnt : bankAcntList) {
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(acnt);
                balanceInfo.setBankCurrency(request.getCurrency());
                Constants.Account bal = QueryUtil.balanceOf(acnt);
                balanceInfo.setCurrentBalance(bal.getBalance());
                balanceInfo.setAvailableBalance(bal.getBalance().subtract(bal.getLockedBalance()));
                balanceInfo.setBalanceDateTime(startDate.atTime(0, 0, 0));
                ret.add(balanceInfo);
            }
            startDate = startDate.plusDays(1L);
        }
        return new EBBankBalanceResponse(ret);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean async() {
        return false;
    }
}

