/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.simulator.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.banks.simulator.utils.Constants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.transform.PaymentTransFormer;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryUtil
extends Constants {
    static final String SELECT_PROPERTIES = "id,key,content_tag,ext";
    static final String ENTITY_NAME = "ebg_simulator";
    static QFilter[] detailFilter = new QFilter[]{new QFilter("key", "=", (Object)"Account")};
    static ConcurrentMap<String, Object> buckets;
    static volatile boolean isInit;

    public static List<PaymentInfo> queryPayments(QFilter filter) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(8);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_bd_paymentinfo", (String)"id,custom_id,version,bank_login_id,ebg_id,bank_version_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,verify_field,amount,currency,use_code,use_cn,explanation,same_bank,same_city,urgent,individual,force,merge,fee_type,booking_time,emails,mobiles,acc_no,acc_name,bank_name,bank_address,area_code,acc_dept,acc_country,acc_province,acc_city,third_acc_no,third_acc_name,third_bank_name,third_bank_address,third_area_code,third_acc_dept,income_acc_no,income_acc_name,income_bank_name,income_bank_address,income_area_code,income_acc_dept,income_swift_code,income_cnaps,income_country,income_province,income_city,status_id,status_name,status_msg,bank_status,bank_msg,error_msg,error_stack,back_status,back_status_msg,back_bank_status,back_bank_msg,back_error_msg,back_error_stack,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_req,submit_count,submit_success_time,last_sync_time,last_sync_request_req,sync_count,pay_finish_date,to_give_up,payer_fee_type,payer_fee_acc_no,payer_fee_currency,exchange_rate,actual_amount,payee_bank_code,transaction_remarks,proxy_acc_no,proxy_acc_name,proxy_bank_country,proxy_bank_area,proxy_bank_swift_code,proxy_bank_name,proxy_bank_address,proxy_fee_type,proxy_fee_currency,pay_currency,ex_contract,bochk_message_bank,bbc_code_words,bank_ref_id,to_ground,iso_currency_code,iso_currency_name,clearing_code,clearing_branch_code,clearing_branch_sub_code,delivery_method,cheque_type,payment_method,service_level,trans_up,linkpay_type,relative_id,linkpay_detail_seq_id,reason,operator,reversed1,reversed2,reversed3,reversed4,reversed_biz_field,reversed_sys_field,income_branch_no,income_branch_name,abstract", (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public static Constants.Account balanceOf(BankAcnt acnt) {
        Map accounts = (Map)QueryUtil.fetchDetail("Account");
        if (accounts.containsKey(acnt.getAccNo())) {
            return (Constants.Account)accounts.get(acnt.getAccNo());
        }
        return QueryUtil.addAcnt(acnt);
    }

    private static Constants.Account addAcnt(String accNo, String accName, String city) {
        Constants.Account account = new Constants.Account();
        account.setAccNo(accNo);
        account.setBalance(defaultBal);
        account.setCity(city == null ? "" : city);
        account.setName(accName);
        account.setLockedBalance(BigDecimal.ZERO);
        Map accounts = (Map)buckets.get("Account");
        accounts.put(accNo, account);
        return account;
    }

    public static Constants.Account addAcnt(BankAcnt x) {
        Constants.Account account = new Constants.Account();
        account.setAccNo(x.getAccNo());
        account.setBalance(defaultBal);
        account.setCity(x.getProvince() == null ? "" : x.getProvince());
        account.setName(x.getAccName());
        account.setLockedBalance(BigDecimal.ZERO);
        Map accounts = (Map)buckets.get("Account");
        accounts.put(x.getAccNo(), account);
        return account;
    }

    public static synchronized Constants.BalPair tx(PaymentInfo paymentInfo, String op) {
        Map accounts = (Map)QueryUtil.fetchDetail("Account");
        Constants.Account payer = accounts.getOrDefault(paymentInfo.getAccNo(), QueryUtil.addAcnt(paymentInfo.getAccNo(), paymentInfo.getAccName(), paymentInfo.getAccCity()));
        Constants.Account payee = accounts.getOrDefault(paymentInfo.getIncomeAccNo(), QueryUtil.addAcnt(paymentInfo.getIncomeAccNo(), paymentInfo.getIncomeAccName(), paymentInfo.getIncomeCity()));
        BigDecimal balance = payer.getBalance();
        BigDecimal payeeBalance = payee.getBalance();
        BigDecimal locked = payer.getLockedBalance();
        try {
            if ("pay".equalsIgnoreCase(op)) {
                if (paymentInfo.getAccNo().startsWith("QF")) {
                    PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"fail", (String)ResManager.loadKDString((String)"QF \u4ed8\u6b3e\u8d26\u6237\uff0c\u4ea4\u6613\u5931\u8d25\uff01", (String)"QueryUtil_0", (String)"ebg-aqap-banks-simulator", (Object[])new Object[0]));
                    return null;
                }
                if (paymentInfo.getIncomeAccNo().startsWith("QF")) {
                    PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"fail", (String)ResManager.loadKDString((String)"QF \u6536\u6b3e\u8d26\u6237\uff0c\u4ea4\u6613\u5931\u8d25\uff01", (String)"QueryUtil_1", (String)"ebg-aqap-banks-simulator", (Object[])new Object[0]));
                    return null;
                }
                if (balance.subtract(locked).compareTo(paymentInfo.getAmount()) < 0) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff01", (String)"QueryUtil_2", (String)"ebg-aqap-banks-simulator", (Object[])new Object[0]));
                }
                BigDecimal newLocked = locked.add(paymentInfo.getAmount());
                payer.setLockedBalance(newLocked);
            } else {
                BigDecimal newBalance = balance.subtract(paymentInfo.getAmount());
                BigDecimal newLocked = locked.subtract(paymentInfo.getAmount());
                BigDecimal newPayeeBalance = payeeBalance.add(paymentInfo.getAmount());
                payer.setBalance(newBalance);
                payer.setLockedBalance(newLocked);
                payee.setBalance(newPayeeBalance);
            }
            QueryUtil.update();
        }
        catch (Exception e) {
            payer.setBalance(balance);
            payer.setLockedBalance(locked);
            payee.setBalance(payeeBalance);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new Constants.BalPair(payer.getBalance(), payee.getBalance());
    }

    public static synchronized void tx(List<PaymentInfo> paymentInfos) {
        BigDecimal locked;
        Map accounts = (Map)QueryUtil.fetchDetail("Account");
        Constants.Account payer = accounts.getOrDefault(paymentInfos.get(0).getAccNo(), QueryUtil.addAcnt(paymentInfos.get(0).getAccNo(), paymentInfos.get(0).getAccName(), paymentInfos.get(0).getAccCity()));
        BigDecimal balance = payer.getBalance();
        if (balance.subtract(locked = payer.getLockedBalance()).compareTo(paymentInfos.get(0).getTotalAmount()) < 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff01", (String)"QueryUtil_2", (String)"ebg-aqap-banks-simulator", (Object[])new Object[0]));
        }
        try {
            for (PaymentInfo paymentInfo : paymentInfos) {
                if (paymentInfo.getAccNo().startsWith("QF")) {
                    PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"fail", (String)ResManager.loadKDString((String)"QF \u4ed8\u6b3e\u8d26\u6237\uff0c\u4ea4\u6613\u5931\u8d25\uff01", (String)"QueryUtil_0", (String)"ebg-aqap-banks-simulator", (Object[])new Object[0]));
                    continue;
                }
                if (paymentInfo.getIncomeAccNo().startsWith("QF")) {
                    PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"fail", (String)ResManager.loadKDString((String)"QF \u6536\u6b3e\u8d26\u6237\uff0c\u4ea4\u6613\u5931\u8d25\uff01", (String)"QueryUtil_1", (String)"ebg-aqap-banks-simulator", (Object[])new Object[0]));
                    continue;
                }
                if (paymentInfo.getAccNo().startsWith("U") || paymentInfo.getIncomeAccNo().startsWith("U")) {
                    PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"unknown", (String)ResManager.loadKDString((String)"U \u4ea4\u6613\u672a\u77e5", (String)"QueryUtil_3", (String)"ebg-aqap-banks-simulator", (Object[])new Object[0]));
                    continue;
                }
                payer.setLockedBalance(locked.add(paymentInfo.getAmount()));
                QueryUtil.update();
            }
        }
        catch (Exception e) {
            payer.setLockedBalance(locked);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static synchronized void update() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])detailFilter);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        }
        QueryUtil.setDynamicParamater(dynamicObject, "key", "Account");
        Map accounts = (Map)QueryUtil.fetchDetail("Account");
        if (accounts.isEmpty()) {
            return;
        }
        Constants.Account[] accArray = accounts.values().toArray(new Constants.Account[0]);
        String savedVal = JSON.toJSONString((Object)accArray);
        QueryUtil.setDynamicParamater(dynamicObject, "content_tag", savedVal);
        SaveServiceHelper.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new DynamicObject[]{dynamicObject});
    }

    private static void init() {
        if (isInit) {
            return;
        }
        buckets = new ConcurrentHashMap<String, Object>(KEYS.length);
        for (String key : KEYS) {
            buckets.putAll(QueryUtil.fetch(key));
        }
        isInit = true;
    }

    public static ConcurrentMap<String, Object> fetch(String key) {
        if (key.equalsIgnoreCase("Account")) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])detailFilter);
            ConcurrentHashMap<String, Object> ret = new ConcurrentHashMap<String, Object>();
            HashMap<String, Constants.Account> accountMap = new HashMap<String, Constants.Account>(8);
            ret.put(key, accountMap);
            if (dynamicObject == null) {
                return ret;
            }
            String content = dynamicObject.getString("content_tag");
            List accounts = JSON.parseArray((String)content, Constants.Account.class);
            for (Constants.Account account : accounts) {
                accountMap.put(account.getAccNo(), account);
            }
            return ret;
        }
        return Maps.newConcurrentMap();
    }

    public static Object fetchDetail(String key) {
        QueryUtil.init();
        return buckets.getOrDefault(key, null);
    }

    public static void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }

    static {
        isInit = false;
    }
}

