/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zzb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Packer;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        Element ebank_root = new Element("Message");
        String accNo = request.getAcnt().getAccNo();
        JDomUtils.addChild((Element)ebank_root, (Element)ZZB_Packer.buildHead(this.getBizCode(), Sequence.gen18Sequence()));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate()));
        if ("0".equalsIgnoreCase(this.getCurrentPage())) {
            this.setCurrentPage(1);
        }
        JDomUtils.addChild((Element)body, (String)"PageNo", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"PageCount", (String)"50");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse response = new EBBankDetailResponse();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = request.getAcnt();
        Element ebenk = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZZB_Parser.parserCommonInfo(ebenk);
        Element body = ebenk.getChild("Body");
        if ("000000".equals(bankResponse.getResponseCode())) {
            int pagesTotal;
            Element lists = body.getChild("List");
            String count = body.getChildText("TotleCount");
            int TotleCount = Integer.parseInt(count);
            if (TotleCount == 0) {
                this.setLastPage(true);
                response.setDetails(detailList);
                return response;
            }
            int currentPage = Integer.parseInt(this.getCurrentPage());
            if (currentPage < (pagesTotal = TotleCount / 50 + 1)) {
                this.setCurrentPage(currentPage + 1);
            } else {
                this.setLastPage(true);
            }
            List list = lists.getChildren("Map");
            for (Element row : list) {
                DetailInfo detail = new DetailInfo();
                String currencyCode = row.getChildTextTrim("CurrencyCode");
                String payeeAcNo = row.getChildTextTrim("PayeeAcNo");
                String payeeAcName = row.getChildTextTrim("PayeeAcName");
                detail.setCurrency(currencyCode);
                detail.setOppAccNo(payeeAcNo);
                detail.setOppAccName(payeeAcName);
                detail.setAccName(acnt.getAccName());
                detail.setAccNo(acnt.getAccNo());
                String transferDate = row.getChildTextTrim("TransDate");
                String transferTime = row.getChildTextTrim("TransTime");
                detail.setTransTime(LocalDateTime.parse(transferDate + " " + transferTime, ZZB_Packer.DATE_TIME_SEPARATION_FORMATTER));
                detail.setTransDate(LocalDate.parse(transferDate, ZZB_Packer.DATE_FORMATTER));
                String payAmount = row.getChildTextTrim("Amount");
                String recAmount = row.getChildTextTrim("Amount");
                BigDecimal payAmountD = new BigDecimal(payAmount);
                BigDecimal recAmountD = new BigDecimal(recAmount);
                String CDFlag = row.getChildTextTrim("DCFlag");
                if (CDFlag.equalsIgnoreCase("D")) {
                    detail.setDebitAmount(payAmountD);
                    detail.setCreditAmount(new BigDecimal(0));
                } else if (CDFlag.equalsIgnoreCase("C")) {
                    detail.setDebitAmount(new BigDecimal(0));
                    detail.setCreditAmount(recAmountD);
                } else {
                    logger.error("\u54cd\u5e94\u6570\u636e\u5b58\u5728\u4e0d\u5408\u89c4\u4fe1\u606f\uff0c\u501f\u8d37\u6807\u8bc6\u8fd4\u56de\u975e\u6b63\u5e38\u503c\uff1a" + CDFlag + "\uff0c\u8bf7\u68c0\u67e5\u3002");
                    continue;
                }
                String AcctBal = row.getChildTextTrim("Balance");
                if (StringUtils.isNotEmpty((String)AcctBal)) {
                    BigDecimal balance = new BigDecimal(AcctBal);
                    detail.setBalance(balance);
                }
                String summary = "";
                if (row.getChildTextTrim("Summary") != null) {
                    summary = row.getChildTextTrim("Summary");
                }
                detail.setExplanation(summary);
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonStr);
                detail.setReceiptNo(receiptNo);
                detail.setJsonMap(jsonStr);
                detail.setBankDetailNo(row.getChildTextTrim("JnlNo"));
                detailList.add(detail);
            }
        } else {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%S\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), body.getChildText("respondInfo"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        response.setDetails(detailList);
        return response;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/B2EActTrsQry.do?";
        s = s + "userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=0&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
    }
}

