/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zzb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_DCFileUtils;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Packer;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Parser;
import kd.ebg.aqap.banks.zzb.dc.services.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPaymImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 2000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "B2EAgentPayeeSalary";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"SalaryPaymImpl_0", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String fileName = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId() + ".txt";
        String fileContent = this.packUploadFileContentStr(paymentInfos);
        String resp = "";
        try {
            new ZZB_DCFileUtils().uploadFile(fileName, fileContent);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5411\u91d1\u8776\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (String)"SalaryPaymImpl_1", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        String uploadHead = this.getUploadFilePackHead("B2EAgentPayeeSalary", fileName, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Object bankReturnFileName = null;
        try {
            String trnCode = "B2EAgentPayeeSalary|" + ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId() + "|" + RequestContextUtils.getBankParameterValue((String)"contractNo");
            RequestContextUtils.setRunningParam((String)"zzbUri", (String)uploadHead);
            resp = this.getUploadBody(((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId(), fileName);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5411\u94f6\u884c\u524d\u7f6e\u673a\u53d1\u8d77\u4e0a\u4f20\u6587\u4ef6\u8bf7\u6c42\u5f02\u5e38\u3002", (String)"SalaryPaymImpl_2", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return resp;
    }

    protected String getUploadBody(String batchID, String filename) {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)ZZB_Packer.buildHead("uploadFile", batchID));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"filename", (String)filename);
        JDomUtils.addChild((Element)body, (String)"transcode", (String)"uploadFile");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }

    private String packUploadFileContentStr(List<PaymentInfo> paymentInfos) {
        int count = paymentInfos.size();
        BigDecimal sumAmount = BigDecimal.valueOf(0L);
        for (int i = 0; i < count; ++i) {
            BigDecimal amount = paymentInfos.get(i).getAmount();
            sumAmount = sumAmount.add(amount);
        }
        StringBuilder spitBuffer = new StringBuilder();
        spitBuffer.append(count).append("|").append(sumAmount.toString()).append("\n");
        for (int i = 0; i < count; ++i) {
            spitBuffer.append(i + 1).append("|");
            spitBuffer.append(paymentInfos.get(i).getIncomeAccName()).append("|");
            spitBuffer.append(paymentInfos.get(i).getIncomeAccNo()).append("|");
            spitBuffer.append(paymentInfos.get(i).getAmount());
            spitBuffer.append("\n");
        }
        return spitBuffer.toString();
    }

    protected String getUploadFilePackHead(String transcode, String fileName, String clientPathID) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eb2e/uploadFile.do?userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=1");
        sb.append("&fileName=");
        sb.append(fileName);
        sb.append("&delete=0");
        sb.append("&transCode=");
        sb.append(transcode);
        sb.append('|');
        sb.append(clientPathID);
        sb.append('|');
        sb.append(RequestContextUtils.getBankParameterValue((String)"contractNo"));
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        List paymentInfos = request.getPaymentInfos();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = bank_root.getChild("Head");
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = ZZB_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if ("000000".equals(bankStatus)) {
            String fileJnINo = head.getChildText("McJnlno");
            if (StringUtils.isEmpty((String)fileJnINo)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryPaymImpl_3", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)"", (String)"");
            } else {
                PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"FileJnINo", (String)fileJnINo);
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPaymImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        } else if ("999999".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryPaymImpl_5", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else if ("validation.errormsg".equals(bankStatus)) {
            if (ZZB_Parser.isTimeOut(headRsp).booleanValue()) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPaymImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryPaymImpl_3", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryPaymImpl_3", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(RequestContextUtils.getRunningParam((String)"zzbUri"));
    }
}

