/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.ext;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.aqap.common.framework.services.BankAreaCodeService;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;

public class AreaStore {
    public static AreaStore instance;
    private Map<String, List<String>> provinceCodes;

    public static synchronized AreaStore getInstance() {
        if (null == instance) {
            instance = new AreaStore();
        }
        return instance;
    }

    public AreaStore() {
        BankAreaCodeService bankAreaCodeService = (BankAreaCodeService)SpringContextUtil.getBean(BankAreaCodeService.class);
        List lists = bankAreaCodeService.getBankAreaInfoByBankVersionId(EBContext.getContext().getBankVersionID());
        if (CollectionUtil.isNotEmpty((Collection)lists)) {
            this.provinceCodes = new HashMap<String, List<String>>(lists.size());
            lists.forEach(bankAreaInfo -> this.provinceCodes.put(bankAreaInfo.getCountryAreaCode(), bankAreaInfo.getKeywords()));
        }
    }

    public String getAreaCodeExt(String provinceOrCity) {
        if (StrUtil.isEmpty((String)provinceOrCity)) {
            return "";
        }
        if (this.provinceCodes == null || this.provinceCodes.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, List<String>> code : this.provinceCodes.entrySet()) {
            String areaCode = code.getKey();
            List<String> keywords = code.getValue();
            if (!CollectionUtil.isNotEmpty(keywords)) continue;
            for (String keyword : keywords) {
                if (!provinceOrCity.contains(keyword)) continue;
                return areaCode;
            }
        }
        return "";
    }
}

