/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABCErrCodeDataBase;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ABC_DC_Parser {
    public static Element parseString2Root(String rspStr) {
        rspStr = rspStr.substring(7);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        return root;
    }

    public static BankResponse parseHeader(Element root) {
        String respCode = root.getChildTextTrim("RespCode");
        String respInfo = root.getChildTextTrim("RespInfo");
        String rxtInfo = root.getChildTextTrim("RxtInfo");
        BankResponse rsp = new BankResponse();
        rsp.setResponseCode(respCode);
        if (PropertiesConstants.getValue((String)"DEAL_SUCCESS").equalsIgnoreCase(respInfo)) {
            rsp.setResponseMessage("");
        } else if (!StrUtil.isEmpty((String)rxtInfo)) {
            rsp.setResponseMessage(rxtInfo);
        } else if (!StrUtil.isEmpty((String)respInfo)) {
            rsp.setResponseMessage(respInfo);
        } else {
            rsp.setResponseMessage(ABCErrCodeDataBase.getValue(respCode));
        }
        return rsp;
    }

    public static boolean isSameBank(String oppAccNo) {
        String temp;
        if (StrUtil.isEmpty((String)oppAccNo)) {
            return false;
        }
        return 15 == oppAccNo.length() && ("0104".equalsIgnoreCase(temp = oppAccNo.substring(4, 8)) || "0004".equalsIgnoreCase(temp));
    }

    public static String parseWaitFlagMsg(Element root) {
        String WaitFlag = "";
        try {
            Element Corp = root.getChild("Corp");
            WaitFlag = Corp.getChildTextTrim("WaitFlag");
            if (StrUtil.isEmpty((String)WaitFlag)) {
                return "";
            }
            if ("1".equalsIgnoreCase(WaitFlag)) {
                WaitFlag = String.format(ResManager.loadKDString((String)"\u843d\u5730\u6807\u5fd7WaitFlag:%1$s(\u94f6\u884c\u843d\u5730\u5904\u7406;\u6b64\u65f6\u7684\u4ea4\u6613\u6210\u529f\u4e3a\u843d\u5730\u6210\u529f\uff0c\u94f6\u884c\u65b9\u843d\u5730\u5904\u7406\u8be5\u4ea4\u6613)\u3002", (String)"ABC_DC_Parser_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), WaitFlag);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790WaitFlag\u6807\u5fd7\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"ABC_DC_Parser_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return WaitFlag;
    }

    public static boolean is17Lehgth() {
        return "true".equalsIgnoreCase(RequestContextUtils.getBankParameterValue((String)"oppAccNo17LengthInDetail"));
    }

    public static String covertCur(String cur) {
        if (StrUtil.isEmpty((String)cur)) {
            return "";
        }
        if ("CNY".equalsIgnoreCase(cur.trim())) {
            return "01";
        }
        return cur.trim();
    }
}

