/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service;

import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.WaitFlagHelper;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ABC_DC_QueryPacker {
    public static String packPaystate(PaymentInfo paymentInfo) {
        if (WaitFlagHelper.isWaitFlag(paymentInfo)) {
            return ABC_DC_QueryPacker.pack_Paystate_CQRA61(paymentInfo);
        }
        if (BankBusinessConfig.isUseCQRT71()) {
            return ABC_DC_QueryPacker.pack_Paystate_CQRT71(paymentInfo);
        }
        return ABC_DC_QueryPacker.pack_Paystate_CQRT04(paymentInfo);
    }

    public static String pack_Paystate_CQRT04(PaymentInfo paymentInfo) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQRT04");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"CmeSeqNo", (String)paymentInfo.getBankDetailSeqId());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public static String pack_Paystate_CQRT71(PaymentInfo paymentInfo) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQRT71");
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"SerialNo", (String)paymentInfo.getBankDetailSeqId());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public static String pack_Paystate_GQLT16(PaymentInfo paymentInfo) {
        Element root = ABC_DC_Packer.createABCRoot4New("GQLT16");
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"SerialNo", (String)paymentInfo.getBankDetailSeqId());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    private static String pack_Paystate_CQRA61(PaymentInfo paymentInfo) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQRA61");
        Element Corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)Corp, (String)"BookingDate", (String)paymentInfo.getBankDetailSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }
}

