/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AggregateHisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRB13", Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)rqst.getBankCurrency());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"QryFlag", (String)"10765");
        JDomUtils.addChild((Element)corp, (String)"StartDate", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)corp, (String)"EndDate", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String[] splits;
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element cmp = root.getChild("Cmp");
        Element cme = root.getChild("Cme");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return new EBBankBalanceResponse((List)Lists.newArrayListWithCapacity((int)1));
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        int fieldNum = Integer.parseInt(fieldNumStr);
        if ("1".equalsIgnoreCase(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getBalanceRspRecords(fileName, "");
        } else {
            String data = cmp.getChildTextTrim("RespPrvData");
            if (data.endsWith("|")) {
                data = data.substring(0, data.length() - 1);
            }
            splits = StringUtils.split((String)data, (String)"|");
        }
        if (splits.length > recordNum) {
            recordNum = splits.length / fieldNum;
        }
        ArrayList<BalanceInfo> resultList = new ArrayList<BalanceInfo>(recordNum);
        for (int i = 0; i < recordNum; ++i) {
            BalanceInfo balance = new BalanceInfo();
            String bal = splits[fieldNum * i + 3];
            String date = splits[fieldNum * i + 4];
            String currency = splits[fieldNum * i + 2];
            String accNo = splits[fieldNum * i + 1];
            this.setCurrentBalance(balance, bal);
            this.setBalanceDateTime(balance, date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            this.setBankCurrency(balance, request.getBankCurrency(), currency);
            if (accNo.equals(AcntNumberHelper.fixAccNoTo15Or19(request.getAcnt().getAccNo()))) {
                balance.setBankAcnt(request.getAcnt());
            } else {
                balance.setError(BalanceUtils.inconsistentAcc());
            }
            resultList.add(balance);
        }
        return new EBBankBalanceResponse(resultList);
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "CQRB13";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f52\u96c6\u8d26\u6237\u5386\u53f2\u53ef\u7528\u4f59\u989d\u67e5\u8be2\u3002", (String)"AggregateHisBalanceImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }
}

