/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CQRA07 {
    public static String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRA07", Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        String accNo = acnt.getAccNo();
        String zzhxh = BankBusinessConfig.getZZHXH(accNo);
        accNo = accNo.substring(0, accNo.length() - zzhxh.length());
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(accNo));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)request.getBankCurrency());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"PrdSeq", (String)zzhxh);
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)acnt.getAccName());
        JDomUtils.addChild((Element)corp, (String)"CshDraFlag", (String)"0");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public static EBBankBalanceResponse parse(BankBalanceRequest request, String r) {
        String requestAccNo = request.getAcnt().getAccNo();
        Element root = ABC_DC_Parser.parseString2Root(r);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element cmp = root.getChild("Cmp");
        String RespPrvData1 = cmp.getChildTextTrim("RespPrvData1");
        String[] temp = StringUtils.split((String)RespPrvData1, (String)"|");
        String accNo = temp[0];
        String balanceStr = temp[2];
        String availBalanceStr = temp[3];
        String currency = temp[6];
        BalanceInfo balance = new BalanceInfo();
        if (StringUtils.isEmpty((String)balanceStr)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getBalanceEmptyThrowTips((String)""));
        }
        BalanceUtil.setCurrentBalance((BalanceInfo)balance, (String)balanceStr);
        BalanceUtil.setAvailableBalance((BalanceInfo)balance, (String)availBalanceStr);
        BankAcnt bankAcnt = new BankAcnt();
        balance.setBankAcnt(bankAcnt);
        BalanceUtil.setBankCurrency((BalanceInfo)balance, (String)request.getBankCurrency(), (String)currency);
        balance.setBalanceDateTime(LocalDateTime.now());
        String zzhxh = BankBusinessConfig.getZZHXH(requestAccNo);
        requestAccNo = requestAccNo.substring(0, requestAccNo.length() - zzhxh.length());
        if (!StrUtil.isEmpty((String)accNo) && (accNo.equalsIgnoreCase(requestAccNo) || accNo.equalsIgnoreCase(AcntNumberHelper.fixAccNoTo15Or19(requestAccNo)))) {
            bankAcnt.setAccNo(request.getAcnt().getAccNo());
        } else {
            balance.setError(BalanceUtils.inconsistentAcc());
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }
}

