/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FixedBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRA08", Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        String accNo = acnt.getAccNo();
        String zzhxh = BankBusinessConfig.getZZHXH(accNo);
        accNo = accNo.substring(0, accNo.length() - zzhxh.length());
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(accNo));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)rqst.getBankCurrency());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)acnt.getAccName());
        JDomUtils.addChild((Element)corp, (String)"CshDraFlag", (String)"0");
        JDomUtils.addChild((Element)corp, (String)"PrdSeq", (String)zzhxh);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        String requestAccNo = rqst.getAcnt().getAccNo();
        String inputBankCurr = rqst.getBankCurrency();
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"FixedBalanceImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (BankResponse)rsp, (String)"0000");
        Element cmp = root.getChild("Cmp");
        String RespPrvData1 = cmp.getChildTextTrim("RespPrvData1");
        String[] temp = StringUtils.split((String)RespPrvData1, (String)"|");
        String accNo = temp[0];
        String balanceStr = temp[2];
        String currency = temp[9];
        BalanceInfo balance = new BalanceInfo();
        balance.setCurrentBalance(new BigDecimal(balanceStr.trim()));
        BankAcnt bankAcnt = new BankAcnt();
        balance.setBankAcnt(bankAcnt);
        balance.setBankCurrency(currency);
        balance.setBalanceDateTime(LocalDateTime.now());
        String zzhxh = BankBusinessConfig.getZZHXH(requestAccNo);
        requestAccNo = requestAccNo.substring(0, requestAccNo.length() - zzhxh.length());
        if (StrUtil.isEmpty((String)accNo) || !accNo.equalsIgnoreCase(requestAccNo) && !accNo.equalsIgnoreCase(AcntNumberHelper.fixAccNoTo15Or19(requestAccNo))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u5e10\u53f7%1$s\u4e0d\u7b49\u4e8e\u67e5\u8be2\u7684\u5e10\u53f7%2$s\uff0c\u8bf7\u68c0\u67e5\u8d26\u6237\u7ef4\u62a4\u662f\u5426\u6b63\u786e\u3002", (String)"FixedBalanceImpl_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), accNo, requestAccNo));
        }
        bankAcnt.setAccNo(rqst.getAcnt().getAccNo());
        String returnBankCurr = balance.getBankCurrency();
        if (inputBankCurr.equalsIgnoreCase(returnBankCurr)) {
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
        }
        String reqCurr = CurrencyUtils.getCurrencyName((String)rqst.getBankCurrency());
        String rspCurr = CurrencyUtils.getCurrencyName((String)returnBankCurr);
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5e01\u79cd(%1$s)\u4e0e\u8d26\u6237\u5b9e\u9645\u5e01\u79cd\u4e0d\u7b26\uff0c\u8bf7\u4ee5[%2$s]\u4f5c\u4e3a\u4f59\u989d\u67e5\u8be2\u7684\u6761\u4ef6\u3002", (String)"FixedBalanceImpl_8", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), reqCurr, rspCurr));
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "CQRA08";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"6.48 \u67e5\u8be2\u5b9a\u671f\u5b58\u6b3e\u8d26\u6237\u4f59\u989d", (String)"FixedBalanceImpl_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        return BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
    }
}

