/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.financing.bug;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IQueryBuyFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryBuyImpl
extends AbstractFinancingImpl
implements IQueryBuyFinancing {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBuyImpl.class);

    public EBBankFinancingResponse doBiz(BankFinancingRequest rqst) {
        EBBankFinancingResponse result = new EBBankFinancingResponse();
        ArrayList infos = new ArrayList(1);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankFinancingResponse response = super.doBiz(rqst);
            infos.addAll(response.getInfos());
        }
        result.setInfos(infos);
        return result;
    }

    public String pack(BankFinancingRequest bankFinancingRequest) {
        BankAcnt acnt = bankFinancingRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQLC11", Sequence.genSequence());
        String contFlag = RequestContextUtils.getRunningParam((String)"contFlag");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"ContFlag", (String)(StringUtils.isNotEmpty((String)contFlag) ? contFlag : ""));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName");
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"ContLast");
        Element pds = JDomUtils.addChild((Element)root, (String)"Pds");
        JDomUtils.addChild((Element)pds, (String)"RedSechType");
        JDomUtils.addChild((Element)pds, (String)"ProNo");
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"PrdSts");
        JDomUtils.addChild((Element)corp, (String)"ActInf", (String)"0");
        String result = ABC_DC_Packer.covert2ABCMessage(root);
        this.logger.info("\u67e5\u8be2\u6301\u6709\u7406\u8d22\u4ea7\u54c1\u4fe1\u606f");
        return result;
    }

    public EBBankFinancingResponse parse(BankFinancingRequest bankFinancingRequest, String rspStr) {
        EBBankFinancingResponse response = new EBBankFinancingResponse();
        List infos = bankFinancingRequest.getInfos();
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u7406\u8d22\u6301\u6709\u7406\u8d22\u4ea7\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s %2$S", (String)"QueryBuyImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cmp = root.getChild("Cmp");
        Element cme = root.getChild("Cme");
        String contFlag = cmp.getChildText("ContFlag");
        if (StringUtils.isEmpty((String)contFlag) || "0".equals(contFlag)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            RequestContextUtils.setRunningParam((String)"contFlag", (String)contFlag);
        }
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            String errorMsg = ResManager.loadKDString((String)"\u519c\u884c\u7406\u8d22\u7533\u8d2d\u540c\u6b65\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u6301\u6709\u7406\u8d22\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"QueryBuyImpl_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        String[] splits = ResponseFileUtils.getDetailRspRecords(fileName, "");
        ArrayList<String> PrdNos = new ArrayList<String>(16);
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = 0; i < recordNum; ++i) {
            String ContractNo = splits[fieldNum * i + 9];
            PrdNos.add(ContractNo);
        }
        String reserved3 = ((FinancingInfo)bankFinancingRequest.getInfos().get(0)).getReserved1();
        if (StringUtils.isEmpty((String)reserved3)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4ea4\u6613\u53f7\u3002", (String)"QueryBuyImpl_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        if (PrdNos.contains(reserved3)) {
            FinancingUtil.setState((List)infos, (FinancingState)FinancingState.SUCCESS, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            FinancingUtil.setState((List)infos, (FinancingState)FinancingState.UNKNOWN, (String)ResManager.loadKDString((String)"\u7b49\u5f85\u4ea4\u5272\u65f6\u95f4", (String)"QueryBuyImpl_8", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        response.setInfos(infos);
        return response;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "CQLC11";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u6301\u6709\u7406\u8d22\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"QueryBuyImpl_9", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return true;
    }
}

