/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.batch.inner;

import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.BatchPayPacker;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.inner.InnerQueryPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryParser;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFileUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;

public class InnerPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(InnerPayImpl.class);

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InnerQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "IBBF02";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5e73\u53f0\u6279\u91cf\u6c47\u5151\uff08IBBF02\uff09", (String)"InnerPayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay_for_salary".equalsIgnoreCase(info.getSubBizType()) && info.is2SameBank() && !info.is2Merge() && info.getTotalCount() > 1 && BankBusinessConfig.isTrans2Batch() || "pay".equalsIgnoreCase(info.getSubBizType()) && !BankBusinessConfig.isGroupAcntPoolTransfer(info.getAccNo(), info.getIncomeAccNo()) && UseConvertor.isSalary((PaymentInfo)info) && info.is2SameBank() && !info.is2Merge() && info.getTotalCount() > 1 && BankBusinessConfig.isTrans2Batch() || "pay".equalsIgnoreCase(info.getSubBizType()) && info.is2Individual() && info.is2SameBank() && info.getTotalCount() > 1 && BankBusinessConfig.isTrans2Batch() || "pay".equalsIgnoreCase(info.getSubBizType()) && !BankBusinessConfig.isGroupAcntPoolTransfer(info.getAccNo(), info.getIncomeAccNo()) && !UseConvertor.isTransfer((PaymentInfo)info) && !UseConvertor.isSalary((PaymentInfo)info) && !info.is2Individual() && info.getTotalCount() > 1 && BankBusinessConfig.isTrans2Batch() && info.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] infos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = infos[0];
        String bizSeqId = request.getHeader().getBizSeqID();
        String fileName = paymentInfo.getBankBatchSeqId();
        String fileContent = BatchPayPacker.packUploadFile(infos, "IBBF02");
        try {
            this.log.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileName + "");
            new ABC_DCFileUtil().uploadFile(fileName, fileContent, bizSeqId);
            this.log.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.log.info(fileContent);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6:%1$s\u5931\u8d25\u3002", (String)"InnerPayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), fileName), (Throwable)e);
        }
        return BatchPayPacker.packBatchPayString(infos, "IBBF02", fileName);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        new SalaryParser().parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

