/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch;

import java.io.OutputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFilePacker;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFileUtil;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ShBatchQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ShBatchPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(ShBatchPayImpl.class);

    public void closeOutputStreamQuietly(OutputStream outputStream) {
    }

    public int getBatchSize() {
        return 2000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return ShBatchQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "C602";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\uff1a\u6279\u91cf\u8bb0\u8d26\u6587\u4ef6\u4e0a\u4f20\u4ea4\u6613\uff08SH04\uff09\u3002", (String)"ShBatchPayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return BankBusinessConfig.isShangHaiPaybatch() && info.is2SameBank() && ("pay_for_salary".equals(info.getSubBizType()) || "pay".equals(info.getSubBizType()));
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        String bizSeqId = request.getHeader().getBizSeqID();
        String fileContent = ABC_DCFilePacker.createSubmitWagePaymentMessage(paymentInfos);
        String fileName = paymentInfo.getBankBatchSeqId();
        try {
            this.log.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileName + "");
            new ABC_DCFileUtil().uploadFile(fileName, fileContent, bizSeqId);
            this.log.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.log.info(fileContent);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20%1$s\u5931\u8d25\u3002", (String)"ShBatchPayImpl_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), fileName), (Throwable)e);
        }
        Element root = ABC_DC_Packer.createABCRoot("C602", paymentInfo.getBankBatchSeqId());
        Element version = JDomUtils.addChild((Element)root, (String)"Version");
        JDomUtils.addChild((Element)version, (String)"CcVersion", (String)"1");
        JDomUtils.addChild((Element)root, (String)"SHAppCode", (String)"SH04");
        JDomUtils.addChild((Element)root, (String)"FileFlag", (String)"1");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName", (String)fileName);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (StringUtils.isEmpty((String)rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u4e0d\u5b58\u5728RespCode\u8282\u70b9\u6216\u8be5\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"ShBatchPayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u519c\u884c\u5df2\u63a5\u6536", (String)"ShBatchPayImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)"", (String)"");
        } else if ("9999".equals(rsp.getResponseCode()) || "CICS".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u5b9a", (String)"ShBatchPayImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ShBatchPayImpl_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

