/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjrcb.cmp.services.detail;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjrcb.cmp.services.Packer;
import kd.ebg.aqap.banks.bjrcb.cmp.utils.DateUtil;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPacker {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailPacker.class);
    public static final String trade_code = "200110";

    public String packTodayDetail(BankDetailRequest request) throws EBServiceException {
        if (this.isOverDateSpan(request)) {
            String msg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\uff0c\u65f6\u95f4\u8de8\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e09\u4e2a\u6708\uff08\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a%1$s\uff0c\u7ed3\u675f\u65f6\u95f4\u4e3a\uff1a%2$s\uff09\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01", (String)"DetailPacker_3", (String)"ebg-aqap-banks-bjrcb-cmp", (Object[])new Object[0]), request.getStartDate(), request.getEndDate());
            log.error(msg);
            throw EBExceiptionUtil.serviceException((String)msg);
        }
        Element ap_root = new Element("ap");
        JDomUtils.addChild((Element)ap_root, (Element)Packer.getCommonHead(trade_code, "0"));
        JDomUtils.addChild((Element)ap_root, (Element)this.getBalanceRequestBody(request));
        String rqstStr = JDomUtils.element2StringPlain((Element)ap_root, (String)"GB18030");
        rqstStr = Packer.packSendMsg(rqstStr, "0");
        return rqstStr;
    }

    private boolean isOverDateSpan(BankDetailRequest request) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtil.LocalDateToDate(request.getStartDate()));
        c.add(2, 3);
        long startTime = c.getTimeInMillis();
        c.setTime(DateUtil.LocalDateToDate(request.getEndDate()));
        long endTime = c.getTimeInMillis();
        return endTime - startTime > 0L;
    }

    private Element getBalanceRequestBody(BankDetailRequest request) throws EBServiceException {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)DateTimeUtils.format((Date)DateUtil.LocalDateToDate(request.getStartDate()), (String)"yyyyMMdd", (TimeZone)TimeZone.getDefault()));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)DateTimeUtils.format((Date)DateUtil.LocalDateToDate(request.getEndDate()), (String)"yyyyMMdd", (TimeZone)TimeZone.getDefault()));
        return body;
    }
}

