/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjrcb.cmp.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjrcb.cmp.services.Parser;
import kd.ebg.aqap.banks.bjrcb.cmp.utils.FileUtil;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class DetailParser {
    public List<DetailInfo> parseTodayDetail(BankDetailRequest bankDetailRequest, String receiveMsg) throws EBServiceException {
        List<DetailInfo> detailInfos;
        Document rspXml = Parser.parseReceiveMsg2Doc(receiveMsg);
        Element head = rspXml.getRootElement().getChild("head");
        String file_flag = head.getChildText("file_flag");
        String ret_code = head.getChildText("ret_code");
        if (ret_code.equals("0000")) {
            Element body = rspXml.getRootElement().getChild("body");
            String recordNum = body.getChildTextTrim("record_num");
            if ("0".equalsIgnoreCase(recordNum)) {
                return new ArrayList<DetailInfo>(1);
            }
            String file_name = body.getChildText("file_name");
            detailInfos = "0".equalsIgnoreCase(file_flag) || StringUtils.isEmpty((String)file_name) ? this.getDetailDataByXML(bankDetailRequest, body) : this.getDetailDataByFile(bankDetailRequest, body);
        } else {
            String ret_msg = head.getChildText("ret_info");
            String ret_extMsg = head.getChildText("ext_info");
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\uff0c\u9644\u52a0\u4fe1\u606f\uff1a%3$s\u3002", (String)"DetailParser_3", (String)"ebg-aqap-banks-bjrcb-cmp", (Object[])new Object[0]), ret_code, ret_msg, ret_extMsg);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        return detailInfos;
    }

    private List<DetailInfo> getDetailDataByFile(BankDetailRequest bankDetailRequest, Element body) throws EBServiceException {
        String file_name = body.getChildText("file_name");
        try {
            String detailsFileContent = FileUtil.getDetailFile(file_name);
            return this.parseCircleRecords(bankDetailRequest, body, detailsFileContent);
        }
        catch (Exception e) {
            if (e instanceof EBServiceException) {
                throw e;
            }
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private List<DetailInfo> getDetailDataByXML(BankDetailRequest bankDetailRequest, Element body) throws EBServiceException {
        return this.parseCircleRecords(bankDetailRequest, body, body.getChildText("serial_record"));
    }

    private List<DetailInfo> parseCircleRecords(BankDetailRequest bankDetailRequest, Element body, String circleRecords) throws EBServiceException {
        int record_num = Integer.parseInt(body.getChildText("record_num"));
        int fields_num = Integer.parseInt(body.getChildText("field_num"));
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(16);
        BankAcnt reqBankAcnt = bankDetailRequest.getAcnt();
        String[] records_array = circleRecords.split("\\|");
        for (int i = 1; i <= record_num; ++i) {
            DetailInfo detailInfo = new DetailInfo();
            int startIndex = i * fields_num;
            detailInfo.setAccName(reqBankAcnt.getAccName());
            detailInfo.setAccNo(reqBankAcnt.getAccNo());
            detailInfo.setBankName(reqBankAcnt.getBankName());
            detailInfo.setBankVersionID(reqBankAcnt.getBankVersionId());
            detailInfo.setBankLoginID(reqBankAcnt.getBankLoginId());
            String tr_acdt = records_array[startIndex + 3];
            String host_serial_no = records_array[startIndex + 5];
            detailInfo.setOppAccNo(records_array[startIndex + 8]);
            detailInfo.setOppAccName(records_array[startIndex + 10]);
            detailInfo.setOppBankName(records_array[startIndex + 11]);
            detailInfo.setCurrency(records_array[startIndex + 2]);
            String transDateStr = records_array[startIndex + 3] + records_array[startIndex + 4];
            LocalDateTime transDatetime = LocalDateTime.parse(transDateStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detailInfo.setTransTime(transDatetime);
            detailInfo.setTransDate(transDatetime.toLocalDate());
            String amount = records_array[startIndex + 25];
            if (StringUtils.isEmpty((String)amount)) {
                amount = "0.00";
            }
            detailInfo.setBalance(new BigDecimal(amount));
            String summary = records_array[startIndex + 34];
            String postscript = records_array[startIndex + 35];
            if (!StringUtils.isEmpty((String)summary)) {
                detailInfo.setExplanation(summary);
            } else {
                detailInfo.setExplanation(postscript);
            }
            String amt = records_array[startIndex + 24];
            String CRDR_FLAG = records_array[startIndex + 23];
            if ("c".equalsIgnoreCase(CRDR_FLAG)) {
                detailInfo.setCreditAmount(new BigDecimal(amt));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            } else {
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(new BigDecimal(amt));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tr_acdt", (Object)tr_acdt);
            jsonObject.put("host_serial_no", (Object)host_serial_no);
            jsonObject.put("crdr_flag", (Object)CRDR_FLAG);
            jsonObject.put("amt", (Object)amt);
            jsonObject.put("SUMMARY", (Object)summary);
            jsonObject.put("POSTSCRIPT", (Object)postscript);
            detailInfo.setJsonMap(jsonObject.toJSONString());
            detailInfo.setBankDetailNo(host_serial_no);
            detailInfoList.add(detailInfo);
        }
        return detailInfoList;
    }
}

