/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service.payment.salary;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bjb.dc.service.PackerUtil;
import kd.ebg.aqap.banks.bjb.dc.service.ParserUtil;
import kd.ebg.aqap.banks.bjb.dc.service.login.LoginImpl;
import kd.ebg.aqap.banks.bjb.dc.service.payment.salary.CommSalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class CommSalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        LoginImpl.getInstance().configFactoryForSession(factory, true);
    }

    public int getBatchSize() {
        return BankBusinessConfig.getBatchPaySize();
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CommSalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "CebankGZBatchPayNewJCOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"CommSalaryPayImpl_0", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay".equals(paymentInfo.getSubBizType()) && BankBusinessConfig.isCebankKHReimburseOp() && paymentInfo.is2Individual() && paymentInfo.is2SameBank()) {
            return true;
        }
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.isCashPoolAcnt(paymentInfo.getAccNo());
    }

    public String pack(BankPayRequest request) {
        return PackerUtil.packSalary(request, "CebankGZBatchPayNewJCOp");
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return ParserUtil.parseSalaryResponse(request, responseStr);
    }
}

