/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service.sign;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.sign.AbstractSignImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.lang3.StringUtils;

public class SignHelper
extends AbstractSignImpl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SignHelper.class);
    private String signDate;

    public String getSignDate() {
        return this.signDate;
    }

    public void setSignDate(String signDate) {
        this.signDate = signDate;
    }

    public static String sign(String data) {
        String encoding = RequestContextUtils.getCharset();
        try {
            int length = data.getBytes(encoding).length;
            RequestContextUtils.setRunningParam((String)"length", (String)Integer.toString(length));
        }
        catch (Exception e) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u62a5\u6587\u5b57\u8282\u957f\u5ea6\u53d6\u503c\u5f02\u5e38\u3002", (String)"SignHelper_0", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
        }
        SignHelper signHelper = new SignHelper();
        signHelper.setSignDate(data);
        return signHelper.doBiz();
    }

    private static String getSignDate(String signData) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{signData}), (Object)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SignHelper_1", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
            int start = signData.indexOf("<sign>");
            int end = signData.indexOf("</sign>");
            Preconditions.checkArgument((start >= 0 && end >= 0 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u8fd4\u56de\u62a5\u6587<sign>\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u4e0d\u5b8c\u6574\u3002", (String)"SignHelper_2", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
            String data = signData.substring(start + "<sign>".length(), end);
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{data}), (Object)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c<sign>\u8282\u70b9\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SignHelper_3", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
            return URLEncoder.encode(data, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u7b7e\u540d\u5931\u8d25", (String)"SignHelper_4", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
    }

    public String pack() {
        return this.signDate;
    }

    public String parse(String responseStr) {
        return SignHelper.getSignDate(responseStr);
    }

    public String getConnectionURI() {
        return "";
    }

    public Map<String, String> getHttpHeader() {
        HashMap headMap = Maps.newHashMapWithExpectedSize((int)16);
        headMap.put("User-Agent", "API");
        headMap.put("Content-Length", RequestContextUtils.getRunningParam((String)"length"));
        headMap.put("Content-Type", "INFOSEC_SIGN/1.0");
        return headMap;
    }
}

