/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AggregateBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            BankAcnt acnt = request.getAcnt();
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0050");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0050-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0050-rq");
            Element account = JDomUtils.addChild((Element)rq, (String)"account");
            JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getCnaps());
            JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0050-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        List list = trn.getChildren("b2e0050-rs");
        for (Element rs : list) {
            Element account = rs.getChild("account");
            String accno = account.getChildTextTrim("actacn");
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, request.getBankAcntList(), accno);
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                Element balance = rs.getChild("balance");
                String bokbal = balance.getChildTextTrim("bokbal");
                String useablequota = balance.getChildTextTrim("useablequota");
                this.setCurrentBalance(balanceInfo, bokbal);
                this.setAvailableBalance(balanceInfo, useablequota);
                balanceInfo.setBankCurrency(request.getBankCurrency());
            } else {
                balanceInfo.setError(ShowTipUtil.getResponseErrorTips((String)another_rspcod, (String)another_rspmsg));
            }
            balances.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "b2e0050";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f52\u96c6\u6237\u5f53\u65e5\u53ef\u7528\u4f59\u989d\u67e5\u8be2\u3002", (String)"AggregateBalanceImpl_5", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

