/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.balance.BankCurrencyMapping;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FixedBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(FixedBalanceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest request) {
        String accno = request.getAcnt().getAccNo();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0130");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0130-rq");
            JDomUtils.addChild((Element)trn, (String)"transtype", (String)"");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0130-rq");
            Element account = JDomUtils.addChild((Element)rq, (String)"account");
            JDomUtils.addChild((Element)account, (String)"actacn", (String)accno);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0130-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        List list = trn.getChildren("b2e0130-rs");
        int size = list.size();
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        ArrayList<String> balanceList = new ArrayList<String>(size);
        ArrayList<String> useableBalanceList = new ArrayList<String>(size);
        try {
            for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                String string = rs.getChildTextTrim("actacn");
                if (!string.equalsIgnoreCase(request.getAcnt().getAccNo())) continue;
                Element another_status = rs.getChild("status");
                String another_rspcod = another_status.getChildTextTrim("rspcod");
                String another_rspmsg = another_status.getChildTextTrim("rspmsg");
                if ("B001".equalsIgnoreCase(another_rspcod)) {
                    String txnamt = rs.getChildTextTrim("txnamt");
                    String useablequota = rs.getChildTextTrim("useablequota");
                    String trncur = rs.getChildTextTrim("trncur");
                    String newBankCurrency = BankCurrencyMapping.getInstance().getNewBankCurrency(trncur);
                    if (!request.getBankCurrency().equalsIgnoreCase(newBankCurrency)) {
                        this.logger.info("\u5b9a\u671f\u6237{}\u7684\u5e01\u522b{}\u4e0e\u8bf7\u6c42\u67e5\u8be2\u5e01\u522b\u4e0d\u4e00\u81f4", new Object[]{string, newBankCurrency});
                        continue;
                    }
                    balanceList.add(txnamt);
                    if (!StringUtils.isNotEmpty((String)useablequota)) continue;
                    useableBalanceList.add(useablequota);
                    continue;
                }
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5b9a\u671f\u6237\u4f59\u989d\u5931\u8d25\uff0c\u5185\u5c42\u54cd\u5e94\u7801:%s\u3002", (String)"FixedBalanceImpl_5", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), another_rspcod + another_rspmsg));
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4f59\u989d\u89e3\u6790\u5f02\u5e38\u3002", (String)"FixedBalanceImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (Throwable)e);
        }
        BigDecimal balance = new BigDecimal("0.0");
        if (CollectionUtil.isNotEmpty(balanceList)) {
            for (String string : balanceList) {
                balance = balance.add(new BigDecimal(string));
            }
        }
        this.logger.info("\u5b9a\u671f\u6237{}\u603b\u4f59\u989d\u4e3a{}", new Object[]{request.getAcnt().getAccNo(), balance});
        BigDecimal useableBalance = new BigDecimal("0.0");
        if (CollectionUtil.isNotEmpty(useableBalanceList)) {
            for (String balanceStr : useableBalanceList) {
                useableBalance = useableBalance.add(new BigDecimal(balanceStr));
            }
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankCurrency(request.getBankCurrency());
        if (balance.compareTo(BigDecimal.ZERO) != 0) {
            balanceInfo.setCurrentBalance(balance);
        }
        if (useableBalance.compareTo(BigDecimal.ZERO) != 0) {
            balanceInfo.setAvailableBalance(useableBalance);
        }
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setBankAcnt(request.getAcnt());
        balances.add(balanceInfo);
        return new EBBankBalanceResponse(balances);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(BankBalanceRequest request) {
        return BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "b2e0130";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4f59\u989d", (String)"FixedBalanceImpl_3", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }
}

