/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.curandfixed.cur2fixed;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.service.curandfixed.InternalCurUtil;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CurAndFixedImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    public int getBatchSize() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = InternalCurUtil.getHeader(token, "b2e0131");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0131-rq");
            JDomUtils.addChild((Element)trn, (String)"transtype", (String)"");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0131-rq");
            JDomUtils.addChild((Element)rq, (String)"insid", (String)curAndFixedInfo.getDetailSeqId());
            Element hactn = JDomUtils.addChild((Element)rq, (String)"hactn");
            Element dactn = JDomUtils.addChild((Element)rq, (String)"dactn");
            JDomUtils.addChild((Element)hactn, (String)"actacn", (String)curAndFixedInfo.getAccNo());
            JDomUtils.addChild((Element)hactn, (String)"curcod", (String)curAndFixedInfo.getCurrency());
            JDomUtils.addChild((Element)dactn, (String)"actacn", (String)curAndFixedInfo.getFixedAccNo());
            JDomUtils.addChild((Element)rq, (String)"savingtype", (String)"02");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal add = amount.add(new BigDecimal(curAndFixedInfo.getAmount()));
            if (add.compareTo(new BigDecimal("10000")) < 0) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"<Check>\u6d3b\u671f\u8f6c\u4e3a\u5b9a\u671f\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e10000</Check>\u3002", (String)"CurAndFixedImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)rq, (String)"txnamt", (String)curAndFixedInfo.getAmount());
            if (curAndFixedInfo.getDepositTermValue() == null || "48".equals(curAndFixedInfo.getDepositTermValue())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"<Check>\u5b58\u671f\u4e3a\u7a7a\u6216\u4e0d\u652f\u6301\u7684\u5b58\u671f\uff0c\u5f53\u524d\u4e2d\u884c\u652f\u6301\u7684\u5b58\u671f\u4e3a1 3 6 12 24 36 60</Check>\u3002", (String)"CurAndFixedImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)rq, (String)"term", (String)curAndFixedInfo.getDepositTermValue());
            JDomUtils.addChild((Element)rq, (String)"cdyon", (String)InternalCurUtil.convertBankDepositTerm(curAndFixedInfo.getNextDepositType()));
            JDomUtils.addChild((Element)rq, (String)"ddate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)rq, (String)"furinfo", (String)curAndFixedInfo.getExplanation());
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0131-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"CurAndFixedImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)rspcod, (String)rspmsg);
        }
        List list = trn.getChildren("b2e0131-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
            } else {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
            }
            String saveno = rs.getChildTextTrim("saveno");
            curAndFixedInfo.setReqNbrWithTag(saveno);
        }
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0131";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d3b\u671f\u5b58\u6b3e\u8f6c\u5b9a\u671f\u5b58\u6b3e", (String)"CurAndFixedImpl_3", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

