/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.curandfixed.query;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.service.curandfixed.InternalCurUtil;
import kd.ebg.aqap.banks.boc.net.service.curandfixed.notice2cur.CancelNotifcationImpl;
import kd.ebg.aqap.banks.boc.net.service.curandfixed.query.QueryBizStatus;
import kd.ebg.aqap.banks.boc.net.service.curandfixed.query.QueryNotifyImpl;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractQueryCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryCurAndFixedImpl
extends AbstractQueryCAFImpl
implements IQueryCurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryCurAndFixedImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        List infos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo info = (CurAndFixedInfo)infos.get(0);
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = InternalCurUtil.getHeader(token, "b2e0130");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0130-rq");
            JDomUtils.addChild((Element)trn, (String)"transtype", (String)"");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0130-rq");
            Element account = JDomUtils.addChild((Element)rq, (String)"account");
            JDomUtils.addChild((Element)account, (String)"actacn", (String)info.getFixedAccNo());
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankCurAndFixedResponse queryCurrentAndFixed(BankCurAndFixedRequest request) {
        CurAndFixedInfo info = (CurAndFixedInfo)request.getCafInfos().get(0);
        if ("cancelNotification".equalsIgnoreCase(request.getHeader().getSubBizType())) {
            return this.ntsCancel(request);
        }
        if (info.isATC()) {
            logger.info(">QueryNotify");
            QueryNotifyImpl queryNotify = new QueryNotifyImpl();
            queryNotify.doBiz(request);
        } else {
            logger.info(">QueryBizStatus");
            QueryBizStatus queryBizStatus = new QueryBizStatus();
            queryBizStatus.queryCurrentAndFixed(request);
        }
        if (info.getStatus().intValue() != CurAndFixedState.SUCCESS.getId()) {
            logger.info(">TX IS NOT SUCCESSFUL");
            EBBankCurAndFixedResponse resp = new EBBankCurAndFixedResponse();
            resp.setDetails(request.getCafInfos());
            return resp;
        }
        logger.info(">After Succeed");
        return this.doBiz(request);
    }

    private EBBankCurAndFixedResponse ntsCancel(BankCurAndFixedRequest request) {
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)request.getCafInfos().get(0);
        EBBankCurAndFixedResponse resp = new EBBankCurAndFixedResponse();
        if (CurAndFixedState.NTS_CANCEL_REQ.getId() == curAndFixedInfo.getStatus().intValue()) {
            return new CancelNotifcationImpl().currentAndFixed(request);
        }
        new QueryNotifyImpl().queryCurrentAndFixed(request);
        if (CurAndFixedState.SUCCESS.getId() == curAndFixedInfo.getStatus().intValue()) {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.NTS_CANCEL_FINISHED, (String)"", (String)"", (String)"");
        } else if (CurAndFixedState.FAIL.getId() == curAndFixedInfo.getStatus().intValue()) {
            curAndFixedInfo.setStatus(Integer.valueOf(CurAndFixedState.NTS_CANCEL_FAILED.getId()));
        } else {
            curAndFixedInfo.setStatus(Integer.valueOf(CurAndFixedState.NTS_CANCEL_SUBMITTED.getId()));
        }
        resp.setDetails(request.getCafInfos());
        return resp;
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0130-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"QueryCurAndFixedImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)rspcod, (String)rspmsg);
        }
        List list = trn.getChildren("b2e0130-rs");
        int size = list.size();
        try {
            for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                String saveNo = rs.getChildTextTrim("saveno");
                if (!saveNo.equalsIgnoreCase(curAndFixedInfo.getReqNbrWithoutTag())) continue;
                Element another_status = rs.getChild("status");
                String another_rspcod = another_status.getChildTextTrim("rspcod");
                String another_rspmsg = another_status.getChildTextTrim("rspmsg");
                if ("B001".equalsIgnoreCase(another_rspcod)) {
                    String dueDate = rs.getChildTextTrim("duedate");
                    String rateDate = rs.getChildTextTrim("valuedate");
                    String rate = rs.getChildTextTrim("rate");
                    String avaBal = rs.getChildTextTrim("avabal");
                    String endDate = rs.getChildTextTrim("enddate");
                    curAndFixedInfo.setRateDate(rateDate);
                    curAndFixedInfo.setRate(rate);
                    curAndFixedInfo.setAccBal(avaBal);
                    curAndFixedInfo.setEndDate(endDate);
                    curAndFixedInfo.setEndIntDate(endDate);
                    curAndFixedInfo.setCloseDate(dueDate);
                    continue;
                }
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"<Check>\u67e5\u8be2\u4ea4\u6613\u8be6\u7ec6\u6570\u636e\u65f6\u5f02\u5e38</Check>\u3002", (String)"QueryCurAndFixedImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
            }
        }
        catch (Exception e) {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"<Check>\u67e5\u8be2\u4ea4\u6613\u8be6\u7ec6\u6570\u636e\u65f6\u5f02\u5e38</Check>\u3002", (String)"QueryCurAndFixedImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)"", (String)e.getMessage());
        }
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "b2e0130";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9a\u671f\u8d26\u6237/\u901a\u77e5\u8d26\u6237\u5f53\u65e5\u4fe1\u606f\u67e5\u8be2", (String)"QueryCurAndFixedImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }
}

