/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.company.fcurrency;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.company.fcurrency.FCurrencyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FCurrencyPayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return FCurrencyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "b2e0062";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5883\u5185\u5916\u5e01\u6c47\u6b3e\u7533\u8bf7", (String)"FCurrencyPayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            List paymentInfos = request.getPaymentInfos();
            if (BankBusinessConfig.isAddKDFlagToPay()) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((List)paymentInfos);
            }
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0062");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            BankAcnt acnt = RequestContextUtils.getRequestContext().getBankAcnt();
            String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency());
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0062-rq");
            for (int i = 0; i < paymentInfos.size(); ++i) {
                PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0062-rq");
                info.setBankRefID(BocNetUtils.getBankDetailSeqId(info));
                JDomUtils.addChild((Element)rq, (String)"insid", (String)BocNetUtils.getInsid(info));
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)BocNetUtils.getSeqIdFromInsid(info.getBankDetailSeqID()));
                Element fractn = JDomUtils.addChild((Element)rq, (String)"fractn");
                JDomUtils.addChild((Element)fractn, (String)"trfdate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)fractn, (String)"trntyp", (String)"T");
                JDomUtils.addChild((Element)fractn, (String)"trnamt", (String)info.getAmount().toString());
                JDomUtils.addChild((Element)fractn, (String)"trncur", (String)bankCurrency);
                JDomUtils.addChild((Element)fractn, (String)"fribkn", (String)info.getAreaCode());
                JDomUtils.addChild((Element)fractn, (String)"feecurcod", (String)info.getPayCurrency());
                JDomUtils.addChild((Element)fractn, (String)"frname", (String)info.getAccName());
                JDomUtils.addChild((Element)fractn, (String)"fraddr", (String)info.getBankAddress());
                String payAccNo = info.getAccNo();
                String orgCode = BankBusinessConfig.getBocNetOrgCode(payAccNo);
                JDomUtils.addChild((Element)fractn, (String)"orgcde", (String)(StrUtil.isEmpty((String)orgCode) ? RequestContextUtils.getBankParameterValue((String)"orgid") : orgCode));
                if (!info.isDiffCurrency()) {
                    JDomUtils.addChild((Element)fractn, (String)"cexamt", (String)info.getAmount().toString());
                    JDomUtils.addChild((Element)fractn, (String)"puract", (String)"");
                    JDomUtils.addChild((Element)fractn, (String)"puramt", (String)"");
                    JDomUtils.addChild((Element)fractn, (String)"cexact", (String)payAccNo);
                } else {
                    JDomUtils.addChild((Element)fractn, (String)"cexact", (String)"");
                    JDomUtils.addChild((Element)fractn, (String)"cexamt", (String)"");
                    JDomUtils.addChild((Element)fractn, (String)"puramt", (String)info.getAmount().toString());
                    JDomUtils.addChild((Element)fractn, (String)"puract", (String)payAccNo);
                }
                JDomUtils.addChild((Element)fractn, (String)"othact", (String)"");
                JDomUtils.addChild((Element)fractn, (String)"othamt", (String)"");
                JDomUtils.addChild((Element)fractn, (String)"feeact", (String)"");
                Element toactn = JDomUtils.addChild((Element)rq, (String)"toactn");
                if (info.getSameBank().booleanValue()) {
                    JDomUtils.addChild((Element)toactn, (String)"bedtyp", (String)"1");
                    JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeAreaCode());
                } else {
                    JDomUtils.addChild((Element)toactn, (String)"bedtyp", (String)"0");
                    JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeCnaps());
                }
                JDomUtils.addChild((Element)toactn, (String)"actacn", (String)info.getIncomeAccNo());
                JDomUtils.addChild((Element)toactn, (String)"toname", (String)info.getIncomeAccName());
                JDomUtils.addChild((Element)toactn, (String)"toaddr", (String)info.getIncomeBankAddress());
                JDomUtils.addChild((Element)toactn, (String)"beaknm", (String)info.getIncomeBankName());
                JDomUtils.addChild((Element)toactn, (String)"beaadr", (String)info.getIncomeBankAddress());
                JDomUtils.addChild((Element)toactn, (String)"bedlnm", (String)"");
                JDomUtils.addChild((Element)toactn, (String)"bedadr", (String)"");
                JDomUtils.addChild((Element)toactn, (String)"bdlact", (String)"");
                JDomUtils.addChild((Element)rq, (String)"furinfo", (String)info.getExplanation());
                String feeMode = "OUR";
                if ("02".equalsIgnoreCase(info.getPayerFeeType())) {
                    feeMode = "BEN";
                } else if ("03".equalsIgnoreCase(info.getPayerFeeType())) {
                    feeMode = "SHA";
                }
                JDomUtils.addChild((Element)rq, (String)"feemode", (String)feeMode);
                CountryISOCode isoCode = ISOCountryUtils.getInstance().getCountryInfoByName(info.getIncomeCountry());
                if (isoCode == null) {
                    isoCode = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
                }
                JDomUtils.addChild((Element)rq, (String)"coucde", (String)isoCode.getNumberCode());
                String pay_mode = "O";
                if ("1".equalsIgnoreCase(info.getPayProperty())) {
                    pay_mode = "P";
                } else if ("0".equalsIgnoreCase(info.getPayProperty())) {
                    pay_mode = "A";
                } else if ("2".equalsIgnoreCase(info.getPayProperty())) {
                    pay_mode = "R";
                }
                JDomUtils.addChild((Element)rq, (String)"paytyp", (String)pay_mode);
                JDomUtils.addChild((Element)rq, (String)"priolv", (String)(info.getUrgent() != false ? "U" : "N"));
                JDomUtils.addChild((Element)rq, (String)"canflg", (String)(info.isBondGoodsFlag() ? "Y" : "N"));
                String payAttribute = "5";
                if ("D".equalsIgnoreCase(info.getPayAttribute())) {
                    payAttribute = "2";
                } else if ("E".equalsIgnoreCase(info.getPayAttribute())) {
                    payAttribute = "1";
                } else if ("M".equalsIgnoreCase(info.getPayAttribute())) {
                    payAttribute = "4";
                } else if ("S".equalsIgnoreCase(info.getPayAttribute())) {
                    payAttribute = "6";
                } else if ("X".equalsIgnoreCase(info.getPayAttribute())) {
                    payAttribute = "0";
                }
                JDomUtils.addChild((Element)rq, (String)"rettyp", (String)payAttribute);
                JDomUtils.addChild((Element)rq, (String)"lstdat", (String)"");
                JDomUtils.addChild((Element)rq, (String)"trncd1", (String)info.getTxCode());
                JDomUtils.addChild((Element)rq, (String)"trnam1", (String)info.getTxAmount());
                JDomUtils.addChild((Element)rq, (String)"trnre1", (String)info.getTxPostscript());
                JDomUtils.addChild((Element)rq, (String)"trncd2", (String)"");
                JDomUtils.addChild((Element)rq, (String)"trnam2", (String)"");
                JDomUtils.addChild((Element)rq, (String)"trnre2", (String)"");
                JDomUtils.addChild((Element)rq, (String)"comnum", (String)"");
                JDomUtils.addChild((Element)rq, (String)"invnum", (String)"");
                JDomUtils.addChild((Element)rq, (String)"whbnum", (String)"");
                JDomUtils.addChild((Element)rq, (String)"comcde", (String)"");
                JDomUtils.addChild((Element)rq, (String)"pernam", (String)info.getApplyName());
                JDomUtils.addChild((Element)rq, (String)"pertel", (String)info.getApplyPhone());
                JDomUtils.addChild((Element)rq, (String)"dectyp", (String)info.getDeclareFlag());
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos;
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError(root, paymentInfos = request.getPaymentInfos());
        if (isError) {
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0062-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"FCurrencyPayImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren("b2e0062-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String insid = rs.getChildTextTrim("insid");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)BocNetUtils.getSeqIdFromInsid(insid));
            if (null == info) continue;
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if ("1014".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if (FailCode.getInstance().isFail(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"FCurrencyPayImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

