/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.linkpay;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.payment.query.b2e0007.QueryPayPacker;
import kd.ebg.aqap.banks.boc.net.service.payment.query.b2e0007.QueryPayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;

public class LinkQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(LinkQueryPayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int getBatchSize() {
        if (BankBusinessConfig.isB2e0017LinkpayType()) {
            return 100;
        }
        return 1;
    }

    public String getDeveloper() {
        return "jianbo_chen";
    }

    public String getBizCode() {
        return "b2e0007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8 - trn-b2e0020-rq ,\u65b0\u7528\u6237\u4f7f\u7528-b2e0017\u63a5\u53e3", (String)"LinkQueryPayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (!BankBusinessConfig.isB2e0017LinkpayType() && paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e2d\u56fd\u94f6\u884c\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\u8054\u52a8\u652f\u4ed8", (String)"LinkQueryPayImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
        }
        return QueryPayPacker.packQueryPay(paymentInfos);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        QueryPayParser.parseQueryPay(paymentInfos, responseStr);
        return new EBBankPayResponse(paymentInfos);
    }
}

