/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.salary;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.banks.boc.net.service.BOC_NET_ProvinceCode;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.BOCUseConvertor;
import kd.ebg.aqap.banks.boc.net.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SingleSalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "b2e0078";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u5feb\u6377\u4ee3\u53d1\u4e1a\u52a1(b2e0078);\u5feb\u6377\u4ee3\u53d1\u4e1a\u52a1\u660e\u7ec6\u67e5\u8be2 (b2e0079)", (String)"SingleSalaryPayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankBatchSeqID((List)paymentInfos);
        }
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0078");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element action = JDomUtils.addChild((Element)trans, (String)"trn-b2e0078-rq");
            if (BankBusinessConfig.isSalaryPaymetByAuthorized()) {
                JDomUtils.addChild((Element)action, (String)"transtype", (String)"1");
            } else {
                JDomUtils.addChild((Element)action, (String)"transtype", (String)"");
            }
            Element record = JDomUtils.addChild((Element)action, (String)"b2e0078-rq");
            String insid = BocNetUtils.getBankBatchSeqId((PaymentInfo)paymentInfos.get(0));
            JDomUtils.addChild((Element)record, (String)"insid", (String)insid);
            for (PaymentInfo paymentInfo : paymentInfos) {
                paymentInfo.setBankRefID(insid);
            }
            BocNetUtils.batchSetReservedSysField(paymentInfos, PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, BocNetUtils.getSeqIdFromInsid(((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID()));
            Element fractn = JDomUtils.addChild((Element)record, (String)"fractn");
            JDomUtils.addChild((Element)fractn, (String)"fribkn", (String)((PaymentInfo)paymentInfos.get(0)).getAreaCode());
            JDomUtils.addChild((Element)fractn, (String)"actacn", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
            JDomUtils.addChild((Element)fractn, (String)"actnam", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
            JDomUtils.addChild((Element)record, (String)"pybcur", (String)"CNY");
            JDomUtils.addChild((Element)record, (String)"pybamt", (String)BigDecimalHelper.plain2((BigDecimal)this.calcTotalAmt(paymentInfos)));
            JDomUtils.addChild((Element)record, (String)"pybnum", (String)("" + paymentInfos.size()));
            JDomUtils.addChild((Element)record, (String)"crdtyp", (String)(((PaymentInfo)paymentInfos.get(0)).getSameBank() != false ? "7" : "6"));
            JDomUtils.addChild((Element)record, (String)"furinfo", (String)BOCUseConvertor.getBocSalaryUse(((PaymentInfo)paymentInfos.get(0)).getUseCN()));
            JDomUtils.addChild((Element)record, (String)"useinf", (String)PaymentUtil.substringChinese((boolean)true, (String)((PaymentInfo)paymentInfos.get(0)).getExplanation(), (int)200, (String)RequestContextUtils.getCharset()));
            JDomUtils.addChild((Element)record, (String)"trfdate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
            for (int i = 0; i < paymentInfos.size(); ++i) {
                Element details = JDomUtils.addChild((Element)record, (String)"detail");
                PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
                if (info.getSameBank().booleanValue()) {
                    JDomUtils.addChild((Element)details, (String)"toibkn", (String)BOC_NET_ProvinceCode.getprovinceCode(info.getIncomeProvince(), info.getIncomeCity()));
                } else {
                    JDomUtils.addChild((Element)details, (String)"toibkn", (String)info.getIncomeCnaps());
                }
                JDomUtils.addChild((Element)details, (String)"tobank", (String)info.getIncomeBankName());
                JDomUtils.addChild((Element)details, (String)"toactn", (String)info.getIncomeAccNo());
                JDomUtils.addChild((Element)details, (String)"pydcur", (String)info.getCurrency());
                JDomUtils.addChild((Element)details, (String)"pydamt", (String)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
                JDomUtils.addChild((Element)details, (String)"toname", (String)info.getIncomeAccName());
                JDomUtils.addChild((Element)details, (String)"toidtp", (String)"");
                JDomUtils.addChild((Element)details, (String)"toidet", (String)"");
                String explanation = PaymentUtil.substringChinese((boolean)true, (String)info.getExplanation(), (int)80, (String)RequestContextUtils.getCharset());
                JDomUtils.addChild((Element)details, (String)"furinfo", (String)(null == info.getExplanation() ? ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"SingleSalaryPayImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]) : explanation));
                JDomUtils.addChild((Element)details, (String)"reserve1", (String)"");
                JDomUtils.addChild((Element)details, (String)"reserve2", (String)"");
                JDomUtils.addChild((Element)details, (String)"reserve3", (String)"");
                JDomUtils.addChild((Element)details, (String)"reserve4", (String)"");
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    private BigDecimal calcTotalAmt(List<PaymentInfo> paymentInfos) {
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)paymentInfos.get(i).getAmount());
        }
        return total;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos;
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError(root, paymentInfos = request.getPaymentInfos());
        if (isError) {
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0078-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if ("1011".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"B001".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren("b2e0078-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String insid = rs.getChildTextTrim("insid");
            String obssid = rs.getChildTextTrim("obssid");
            EBGBusinessUtils.setBankRefId((List)paymentInfos, (String)obssid);
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if ("1014".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if (FailCode.getInstance().isFail(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"SingleSalaryPayImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

