/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.detail;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.helper.Packer;
import kd.ebg.aqap.banks.bsz.dc.helper.Parser;
import kd.ebg.aqap.banks.bsz.dc.services.detail.DetailPage;
import kd.ebg.aqap.banks.bsz.dc.utils.ApiUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    static final int PAGE_SIZE = 50;

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("0");
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(request);
            if (Objects.nonNull(response) && Objects.nonNull(response.getDetails())) {
                detailInfos.addAll(response.getDetails());
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        try {
            super.setDetailImpl();
            Map bodyMap = Packer.getSendObject(request, this.getBizCode());
            bodyMap.put("PAGE_ROW_COUNT", 50);
            bodyMap.put("CURRENT_PAGE", this.getCurrentPage());
            logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)bodyMap.toString());
            String responseStr = ApiUtils.doPostRequest(bodyMap);
            logger.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseStr);
            return this.parse(request, responseStr);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            logger.error("\u67e5\u8be2\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38", (String)"DetailImpl_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u51fa\u73b0\u5f02\u5e38:%s", (String)"DetailImpl_1", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    public String pack(BankDetailRequest request) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        List detailList = new ArrayList(16);
        try {
            if (DetailPage.isLastPage(responseStr, this.getCurrentPage())) {
                this.setLastPage(true);
            }
            Root root = Parser.getRecvObject(responseStr, this.getBizCode());
            detailList = (List)Parser.analyse(this.getBizCode(), request, root);
            return new EBBankDetailResponse(detailList);
        }
        catch (Exception e) {
            this.setLastPage(true);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u4ea4\u6613\u660e\u7ec6\u62a5\u6587\u5f02\u5e38\uff1a%s", (String)"DetailImpl_2", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "OPCB000024";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3", (String)"DetailImpl_3", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]);
    }
}

