/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000025_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000025_ReceiveItem;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000025_Send;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.constants.BSZConstants;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.IMiniService;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OPCB000025
implements IMiniService<Root<Header4Send, OPCB000025_Send>, Root<Header4Receive, OPCB000025_Receive>, List<PaymentInfo>, List<PaymentInfo>> {
    public static String transCode = "OPCB000025";

    public static OPCB000025 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000025_Send> getSendRoot(List<PaymentInfo> paymentInfos) throws Exception {
        Root<Header4Send, OPCB000025_Send> root = new Root<Header4Send, OPCB000025_Send>();
        OPCB000025_Send body = new OPCB000025_Send();
        PaymentInfo paymentInfo = paymentInfos.get(0);
        body.setTRAN_CODE(transCode);
        String FLOW_NO = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"ORDER_FLOWNO");
        String ORG_LOW_NO = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"CONSUMER_SEQ_NO");
        if (StringUtils.isEmpty((String)FLOW_NO) && StringUtils.isEmpty((String)ORG_LOW_NO)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u5355\u636e\u65e0\u6d41\u6c34\u53f7\uff0c\u65e0\u6cd5\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001", (String)"OPCB000025_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        body.setFLOW_NO(FLOW_NO);
        body.setORG_LOW_NO(ORG_LOW_NO);
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000025_Receive> getrecvRoot(String rspStr) {
        Root root = (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000025_Receive>>(){}, (Feature[])new Feature[0]);
        return root;
    }

    @Override
    public List<PaymentInfo> recvStrategy(Root<Header4Receive, OPCB000025_Receive> root, List<PaymentInfo> paymentInfos) throws Exception {
        Header4Receive header = root.getHeader();
        OPCB000025_Receive body = root.getBody();
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"body\u8282\u70b9\u4e0d\u5b58\u5728", (String)"OPCB000025_1", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), (String)headStatusCode, (String)headStatusMsg);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000025_2", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        List<OPCB000025_ReceiveItem> items = body.getRESULT_ARRAY();
        if (items.isEmpty()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u4ed8\u6b3e\u7ed3\u679c\u8bb0\u5f55", (String)"OPCB000025_3", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        for (OPCB000025_ReceiveItem item : items) {
            String statusCode;
            String statusExpr;
            PaymentInfo info = Utils.selectPaymentrInfoFromOFN(paymentInfos, item.getOLD_ORDER_FLOWNO());
            String ORDER_FLOWNO = Utils.nullAsBlank(item.getORDER_FLOWNO());
            if (!StringUtils.isEmpty((String)ORDER_FLOWNO)) {
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)"ORDER_FLOWNO", (String)ORDER_FLOWNO);
            }
            if (StringUtils.isEmpty((String)(statusExpr = Utils.nullAsBlank(BSZConstants.STATUS_MAP.get(statusCode = Utils.nullAsBlank(item.getORDER_STATE())))))) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u65e0\u6cd5\u8bc6\u522b\u72b6\u6001\u7801:%s", (String)"OPCB000025_4", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), statusCode), (String)headStatusCode, (String)headStatusMsg);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u65e0\u6cd5\u8bc6\u522bbody\u72b6\u6001\u7801\uff1a%s", (String)"OPCB000025_5", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), statusCode));
            }
            String statusMsg = Utils.nullAsBlank(item.getRET_MESSAGE());
            if (statusCode.equals("90")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)statusExpr, (String)statusCode, (String)statusMsg);
                continue;
            }
            if (statusCode.equals("91")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)statusExpr, (String)statusCode, (String)statusMsg);
                continue;
            }
            if (statusCode.equals("96") || statusCode.equals("99") || statusCode.equals("00")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)statusExpr, (String)statusCode, (String)statusMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)statusExpr, (String)statusCode, (String)statusMsg);
        }
        return paymentInfos;
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    private static class Holder {
        private static final OPCB000025 instance = new OPCB000025();

        private Holder() {
        }
    }
}

