/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.utils;

import com.bsz.becp.netpay.BSZBECPClient;
import com.bsz.becp.signature.BSZBCEPSetting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.utils.KeyStoreUtil;
import kd.ebg.aqap.proxy.oversea.utils.OverseaFileStorageUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class ApiUtils {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(ApiUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BSZStruct buildPropFile() {
        boolean isSucc;
        Properties prop = new Properties();
        BSZStruct st = new BSZStruct();
        String certCipher = RequestContextUtils.getBankParameterValue((String)"private_cipher");
        String url = RequestContextUtils.getBankParameterValue((String)"ip");
        String signFlag = RequestContextUtils.getBankParameterValue((String)"is_sign");
        String serverPK = KeyStoreUtil.getPublicPK();
        String fileName = "private.sm2";
        String privateFileName = "private.cer";
        BSZStruct bszStruct = ApiUtils.createFile(fileName, KeyStoreUtil.getPrivateCertChain());
        BSZStruct bszPrivateCertStruct = ApiUtils.createFile(privateFileName, KeyStoreUtil.getPrivateCertFile());
        String clientSM2FilePath = bszStruct.getFileName();
        String certSecretFilePath = bszPrivateCertStruct.getFileName();
        prop.setProperty("ApiURL", url);
        prop.setProperty("ClientPublicKey", serverPK);
        prop.setProperty("ClientSM2File", clientSM2FilePath);
        prop.setProperty("CertSecretKey", certCipher);
        prop.setProperty("CertSecretFile", certSecretFilePath);
        prop.setProperty("SignFlag", signFlag);
        prop.setProperty("ReadTimeout", "60000");
        prop.setProperty("ConnTimeout", "60000");
        prop.setProperty("EnableLog", "true");
        String logPath = String.format("%s/ebg/BSZ/log/", System.getProperty("user.dir"));
        File logFile = FileCommonUtils.getFileByPath((String)logPath);
        if (!logFile.exists()) {
            logFile.mkdirs();
        }
        prop.setProperty("LogPath", logPath);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        String configPath = OverseaFileStorageUtil.getStorageRootPath() + File.separator + bankLoginId;
        File fp = FileCommonUtils.getFileByPath((String)configPath);
        if (!fp.exists() && !(isSucc = fp.mkdirs())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519", (String)"ApiUtils_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        File configFile = FileCommonUtils.getFileByPath((String)(configPath + File.separator + "config.properties"));
        try (FileOutputStream os = new FileOutputStream(configFile);){
            prop.store(os, "");
            st.setFileName(configPath + File.separator + "config.properties");
            st.setPath(configFile.toPath());
            BSZStruct bSZStruct = st;
            return bSZStruct;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BSZStruct createFile(String name, byte[] content) {
        boolean isSucc;
        String bankLoginId = EBContext.getContext().getBankLoginID();
        String configPath = OverseaFileStorageUtil.getStorageRootPath() + File.separator + bankLoginId;
        BSZStruct st = new BSZStruct();
        String fileName = configPath + File.separator + name;
        File fp = FileCommonUtils.getFileByPath((String)configPath);
        if (!fp.exists() && !(isSucc = fp.mkdirs())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519", (String)"ApiUtils_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        try {
            Path path = Paths.get(fileName, new String[0]);
            Files.deleteIfExists(Paths.get(fileName, new String[0]));
            Files.createFile(path, new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                os.write(content);
                os.flush();
                st.setFileName(fileName);
                st.setPath(path);
                BSZStruct bSZStruct = st;
                return bSZStruct;
            }
        }
        catch (Exception e) {
            logger.info("\u6587\u4ef6\u521b\u5efa\u8fc7\u7a0b\u51fa\u9519", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String doPostRequest(Map bodyMap) {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ApiUtils.buildPropFile();
        String configPath = OverseaFileStorageUtil.getStorageRootPath() + File.separator + bankLoginId + "/config.properties";
        logger.info("\u5f00\u59cb\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\uff1a{}", (Object)configPath);
        BSZBECPClient Nss = new BSZBECPClient();
        BSZBCEPSetting.isAPIInitialize = false;
        Nss.initialize(configPath);
        String rep = Nss.sendAndReceive(bodyMap);
        return rep;
    }

    static class BSZStruct {
        private String fileName;
        private Path path;

        BSZStruct() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }
    }
}

