/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.utils;

import com.bsz.becp.signature.BSZJSONRequest;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.BankBusinessConfig;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;

public class Utils {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(Utils.class);
    private static final String RET_MSG = "RET_MSG";
    private static final String DETAIL_NOT_FOUND_CODE = "HDQP2001";
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static String toHexString(long x) {
        StringBuffer sb = new StringBuffer();
        while (x > 0L) {
            char c = hexDigits[(int)(x & 0xFL)];
            sb.insert(0, c);
            x >>>= 4;
        }
        return new String(sb);
    }

    public static String getRecvMsg(String responseMsg) throws Exception {
        BSZJSONRequest reponseJson = new BSZJSONRequest();
        String retCode = reponseJson.getErrorCode(responseMsg);
        if ("0".equals(retCode) || "000000".equals(retCode)) {
            return reponseJson.getPlainData(responseMsg);
        }
        if (DETAIL_NOT_FOUND_CODE.equals(retCode)) {
            return reponseJson.getPlainData(responseMsg);
        }
        String retMsg = Utils.getDataFromRspHeader(responseMsg, RET_MSG);
        retMsg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684RET_CODE\u4e3a%1$s,RET_MSG\u4e3a%2$s", (String)"Utils_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), retCode, retMsg);
        logger.error("\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + retMsg);
        throw EBExceiptionUtil.serviceException((String)retMsg);
    }

    public static PaymentInfo selectPaymentrInfoFromOFN(List<PaymentInfo> infos, String orderFlowNo) {
        for (PaymentInfo info : infos) {
            if (!orderFlowNo.contains(PaymentInfoSysFiled.get((PaymentInfo)info, (String)"CONSUMER_SEQ_NO"))) continue;
            return info;
        }
        return null;
    }

    public static PaymentInfo selectPaymentrInfoFromBatch(List<PaymentInfo> infos, String orderFlowNo) {
        for (PaymentInfo info : infos) {
            if (!Objects.equals(orderFlowNo, info.getDetailBizNo())) continue;
            return info;
        }
        return null;
    }

    public static String getBankBatchSeqId(PaymentInfo info) throws Exception {
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
            String exp = BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)info.getExplanation());
            return exp;
        }
        return info.getBankBatchSeqId();
    }

    public static String getTotalAmount(List<PaymentInfo> paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.setScale(2, 4).toString();
    }

    public static String nullAsBlank(String msg) {
        return StringUtils.isEmpty((String)msg) ? "" : msg;
    }

    public static String nullAsBlank(MultiLangEnumBridge msg) {
        if (msg != null) {
            return StringUtils.isEmpty((String)msg.loadKDString()) ? "" : msg.loadKDString();
        }
        return "";
    }

    public static BigDecimal notNullBigDecimalBalance(String amountStr) throws Exception {
        if (!StringUtils.isEmpty((String)amountStr)) {
            try {
                return new BigDecimal(amountStr.trim());
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8d26\u6237\u4f59\u989d\u51fa\u9519\uff0c\u4f59\u989d\u4e3a:%s", (String)"Utils_1", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), amountStr), (Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a", (String)"Utils_2", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
    }

    public static void checkRspCode(String responseCode, String responseMessage, String successCode) throws Exception {
        if (!successCode.equals(responseCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)responseCode, (String)responseMessage));
        }
    }

    public static LocalDateTime parserDateTime(String dateStr, String formatter) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(formatter);
        return LocalDateTime.parse(dateStr, dateTimeFormatter);
    }

    public static boolean allfieldIsNUll(Object o) {
        return o == null;
    }

    public static String getDataFromRspHeader(String rsp, String feildName) {
        JSONObject jsonContent = JSONObject.fromObject((Object)rsp);
        JSONObject jsonBody = jsonContent.getJSONObject("header");
        return jsonBody.getString(feildName);
    }
}

