/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jxb.dc.service.payment.otherbank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxb.dc.service.payment.samebank.SameBankQueryPayImpl;
import kd.ebg.aqap.banks.jxb.dc.service.util.Packer;
import kd.ebg.aqap.banks.jxb.dc.service.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SameBankQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "Transfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26", (String)"OtherBankPayImpl_0", (String)"ebg-aqap-banks-jxb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        return !paymentInfo.is2SameBank() && !"overseaPay".equals(subBizType);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = Packer.buildHead(paymentInfos[0].getBankDetailSeqId());
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerBankAcType", (String)"02");
        JDomUtils.addChild((Element)body, (String)"PayerCurrency", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"Amount", (String)paymentInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"PayeeAcNo", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"PayeeAcName", (String)paymentInfos[0].getIncomeAccName());
        SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
        String settBankName = paymentInfos[0].getIncomeBankName();
        String settNo = settBankKeyWordsRepository.matchBankNoByKey(settBankName);
        if (StringUtils.isEmpty((String)settNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u6e05\u7b97\u884c\u884c\u53f7,\u8bf7\u5728\u6e05\u7b97\u884c\u7ba1\u7406\u9875\u9762\u7ef4\u62a4\u6e05\u7b97\u884c\u53f7", (String)"OtherBankPayImpl_2", (String)"ebg-aqap-banks-jxb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"UnionDeptId", (String)settNo);
        JDomUtils.addChild((Element)body, (String)"Priority", (String)"1");
        JDomUtils.addChild((Element)body, (String)"Remark", (String)paymentInfos[0].getExplanation());
        JDomUtils.addChild((Element)body, (String)"SysFlag", (String)"1");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"FIN0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherBankPayImpl_3", (String)"ebg-aqap-banks-jxb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"Body");
        String status = JDomUtils.getChildText((Element)resBody, (String)"_JnlStatus");
        if ("0".equalsIgnoreCase(status) || "w".equalsIgnoreCase(status) || "6".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)("0".equalsIgnoreCase(status) ? ResManager.loadKDString((String)"\u8f6c\u8d26\u6210\u529f", (String)"OtherBankPayImpl_4", (String)"ebg-aqap-banks-jxb-dc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f85\u94f6\u884c\u5ba1\u6838", (String)"OtherBankPayImpl_5", (String)"ebg-aqap-banks-jxb-dc", (Object[])new Object[0])));
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "Transfer", "1");
    }
}

