/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.czccb.dc.service.balace;

import kd.ebg.aqap.banks.czccb.dc.service.Packer;
import kd.ebg.aqap.banks.czccb.dc.service.SignService;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.egf.common.exception.EBServiceException;

public class TodayBalancePacker {
    public String packTodayBalance(BankBalanceRequest rqst) throws EBServiceException {
        String header = Packer.createHeadMessage("CBE010101");
        String body = this.createBody(rqst, rqst.getAcnt().getAccNo());
        String reqMsg = header + body;
        String signData = SignService.getSignData(reqMsg, "UTF-8");
        reqMsg = header + body + signData;
        String strLen = Packer.getLength(reqMsg);
        return strLen + reqMsg;
    }

    private String createBody(BankBalanceRequest rqst, String accountNo) throws EBServiceException {
        String encoding = "UTF-8";
        StringBuilder sbBody = new StringBuilder();
        sbBody.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\"?>\r\n");
        sbBody.append("<BankData>");
        sbBody.append("<opReq>");
        sbBody.append("<ReqParam>");
        sbBody.append("<accountNo>").append(accountNo).append("</accountNo>");
        sbBody.append("<currencyType>").append(rqst.getBankCurrency()).append("</currencyType>");
        sbBody.append("</ReqParam>");
        sbBody.append("</opReq>");
        sbBody.append("</BankData>");
        return sbBody.toString();
    }
}

