/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tccb.dc.services.payment.inner;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tccb.dc.services.payment.inner.InnerBankQueryPayImpl;
import kd.ebg.aqap.banks.tccb.dc.utils.TCommon;
import kd.ebg.aqap.banks.tccb.dc.utils.TPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InnerBankPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(InnerBankPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InnerBankQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2eTransferInBank";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"InnerBankPayImpl_0", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"InnerBankPayImpl_1", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        String resultStr = "";
        String req_no = Sequence.genSequence();
        String tr_code = "B2eTransferInBank";
        String userID = RequestContextUtils.getBankParameterValue((String)"userID");
        String userPassword = RequestContextUtils.getBankParameterValue((String)"userPassword");
        String operatorID = RequestContextUtils.getBankParameterValue((String)"operatorID");
        LocalDateTime now = LocalDateTime.now();
        String d = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        Element transaction = TPacker.createCommonHead(tr_code, userID, userPassword, operatorID, req_no, "1", d);
        Element RequestBody = JDomUtils.addChild((Element)transaction, (String)"RequestBody");
        Element RequestRecord = JDomUtils.addChild((Element)RequestBody, (String)"RequestRecord");
        JDomUtils.addChild((Element)RequestRecord, (String)"AcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)RequestRecord, (String)"PayeeAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)RequestRecord, (String)"Amount", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)RequestRecord, (String)"Note", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)RequestRecord, (String)"Sendjnlno", (String)paymentInfo.getPackageId());
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2String((Element)transaction, (String)encoding);
        return xmlMsg;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        List paymentInfos = request.getPaymentInfos();
        Element transaction = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element RespondHeader = transaction.getChild("RespondHeader");
        BankResponse response = TCommon.parseBankResponse(RespondHeader);
        if (!"RET2000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"InnerBankPayImpl_2", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"InnerBankPayImpl_3", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = TCommon.getEncoding();
        factory.setUri(TPacker.getHttpUrl("pay"));
        factory.setHttpHeader("content-type", "text/xml; charset=" + encoding);
    }
}

