/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.ccip.services.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.ccip.common.CDBBankResponse;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonPacker;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonParser;
import kd.ebg.aqap.banks.cdb.ccip.helper.LoginUtils;
import kd.ebg.aqap.banks.cdb.ccip.services.payment.PaymentStateEnum;
import kd.ebg.aqap.banks.cdb.ccip.util.JDomExtUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Content;
import org.jdom2.Element;

public class CZQueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CZQueryPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        LoginUtils.getInstance().doBiz();
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1G015005", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("O0220001", paymentInfo.getBankBatchSeqId());
        body.addContent((Content)request);
        String Cst_Dlv_Dt = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"Cst_Dlv_Dt");
        JDomExtUtils.addChildCDData(request, "WF_FCN_ID", "G0010000");
        JDomExtUtils.addChildCDData(request, "BIZ_SUB_FCN_ID", "G0010002");
        JDomExtUtils.addChildCDData(request, "EBnk_SvAr_ID", RequestContextUtils.getBankParameterValue((String)"CoustomerNo"));
        JDomExtUtils.addChildCDData(request, "Aply_Aprv_Ind", "0");
        JDomExtUtils.addChildCDData(request, "CstPty_TxnSrlNo", paymentInfo.getBankDetailSeqId());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        rspStr = CommonParser.preParse(rspStr);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        CDBBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u6216\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7ed3\u679c\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"CZQueryPaymentImpl_0", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String recNum = JDomExtUtils.getChildText((Element)response, (String)"Bsn_St_CD");
        PaymentStateEnum state = PaymentStateEnum.getEnumByTypeAndPid("P1G015005", recNum);
        String bankMsg = state.getBankMsg();
        PaymentState paymentState = state.getState();
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)paymentState, (String)paymentState.getCnName(), (String)recNum, (String)bankMsg);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1G015005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d22\u8d44\u6237\u67e5\u8be2\u8f6c\u8d26", (String)"CZQueryPaymentImpl_1", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]);
    }
}

