/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzcb.dc.services.balance;

import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzcb.dc.GZCBEBankDataHelper;
import kd.ebg.aqap.banks.gzcb.dc.helper.DomHelper;
import kd.ebg.aqap.banks.gzcb.dc.loginout.LoginAndOut;
import kd.ebg.aqap.banks.gzcb.dc.sign.SignService;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private int contentLength = 0;

    public String pack(BankBalanceRequest bankBalanceRequest) {
        String sessionId = LoginAndOut.getLoginAndOut().loginSessionId4Query();
        Element GZCBEBankData = new Element("GZCBEBankData");
        Element opReq = JDomUtils.addChild((Element)GZCBEBankData, (String)"opReq");
        String serialNo = RequestContextUtils.getRequestContext().getBankRequestSeq();
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
        String date = DateUtil.formatDateTime((Date)new Date());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)date);
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"ZHHA", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"BIZH", (String)bankBalanceRequest.getBankCurrency());
        String sign = serialNo + "|" + date + "|" + bankBalanceRequest.getAcnt().getAccNo() + "|" + bankBalanceRequest.getBankCurrency() + "|";
        Element signInfo = JDomUtils.addChild((Element)GZCBEBankData, (String)"signInfo");
        SignService signService = new SignService();
        JDomUtils.addChild((Element)signInfo, (String)"signed_data", (String)signService.sign(sign));
        Document document = new Document(GZCBEBankData);
        String xml = DomHelper.doc2StringPlain(document, RequestContextUtils.getCharset());
        String saq = GZCBEBankDataHelper.add(xml, sessionId, "srv004_accountBalanceQuery");
        try {
            this.contentLength = saq.getBytes(RequestContextUtils.getCharset()).length;
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return saq;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element opRep = GZCBEBankDataHelper.checkHead(rspStr);
        Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
        String ZHHA = DomHelper.getChildTextNotNull(opResult, "ZHHA");
        if (!bankBalanceRequest.getAcnt().getAccNo().equals(ZHHA)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u5e10\u53f7%1$s\u4e0d\u7b49\u4e8e\u67e5\u8be2\u7684\u5e10\u53f7%2$s\u3002", (String)"BalanceImpl_9", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), ZHHA, bankBalanceRequest.getAcnt().getAccNo()));
        }
        String ZHYE = DomHelper.getChildTextNotNull(opResult, "ZHYE", ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        String KYYE = DomHelper.getChildTextNotNull(opResult, "KYYE", ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        String SRYE = DomHelper.getChildTextNotNull(opResult, "SRYE", ResManager.loadKDString((String)"\u4e0a\u65e5\u4f59\u989d", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        String BIZH = DomHelper.getChildTextNotNull(opResult, "BIZH", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        BalanceInfo balance = new BalanceInfo();
        balance.setBankAcnt(bankBalanceRequest.getAcnt());
        balance.setBalanceDateTime(LocalDateTime.now());
        this.setCurrentBalance(balance, ZHYE);
        this.setAvailableBalance(balance, KYYE);
        this.setLastDayAvlBalance(balance, SRYE);
        balance.setBankCurrency(BIZH);
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        rsp.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
        return rsp;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "srv004_accountBalanceQuery";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2 srv004_accountBalanceQuery\u3002", (String)"BalanceImpl_8", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = RequestContextUtils.getCharset();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"uri"));
        factory.setHttpHeader("Content-Length", Integer.toString(this.contentLength));
        factory.setHttpHeader("Content-Type", "text/xml; charset=" + encoding);
    }
}

