/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzcb.dc.services.detail;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzcb.dc.GZCBEBankDataHelper;
import kd.ebg.aqap.banks.gzcb.dc.helper.DomHelper;
import kd.ebg.aqap.banks.gzcb.dc.loginout.LoginAndOut;
import kd.ebg.aqap.banks.gzcb.dc.sign.SignService;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private int contentLength = 0;

    public String pack(BankDetailRequest bankDetailRequest) {
        String sessionId = LoginAndOut.getLoginAndOut().loginSessionId4Query();
        Element GZCBEBankData = new Element("GZCBEBankData");
        Element opReq = JDomUtils.addChild((Element)GZCBEBankData, (String)"opReq");
        String serialNo = RequestContextUtils.getRequestContext().getBankRequestSeq();
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
        String date = DateUtil.formatDateTime((Date)new Date());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)date);
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"ZHHA", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"CXFS", (String)"1");
        JDomUtils.addChild((Element)ReqParam, (String)"QSRQ", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)ReqParam, (String)"ZZRQ", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String sign = serialNo + "|" + date + "|" + bankDetailRequest.getAcnt().getAccNo() + "|" + "1" + "|" + bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "|" + bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "|";
        Element signInfo = JDomUtils.addChild((Element)GZCBEBankData, (String)"signInfo");
        SignService signService = new SignService();
        JDomUtils.addChild((Element)signInfo, (String)"signed_data", (String)signService.sign(sign));
        Document document = new Document(GZCBEBankData);
        String xml = DomHelper.doc2StringPlain(document, RequestContextUtils.getCharset());
        String satf = GZCBEBankDataHelper.add(xml, sessionId, "srv005_accountTradeInfoQuery");
        try {
            this.contentLength = satf.getBytes(RequestContextUtils.getCharset()).length;
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return satf;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        Element opRep = GZCBEBankDataHelper.checkHead(rspStr);
        Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
        String ZHHA = DomHelper.getChildTextNotNull(opResult, "ZHHA", ResManager.loadKDString((String)"\u8d26\u53f7", (String)"DetailImpl_0", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        if (!ZHHA.equals(bankDetailRequest.getAcnt().getAccNo())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7(%1$s)\u548c\u8bf7\u6c42\u8d26\u53f7(%2$s)\u4e0d\u7b26", (String)"DetailImpl_17", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), ZHHA, bankDetailRequest.getAcnt().getAccNo()));
        }
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(8);
        Element opResultSet = DomHelper.getChildElementNotNull(opRep, "opResultSet");
        List rows = opResultSet.getChildren("opResult");
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String JYRQ = DomHelper.getChildTextNotNull(row, "JYRQ", ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailImpl_4", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String JYSJ = DomHelper.getChildTextNotNull(row, "JYSJ", ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4", (String)"DetailImpl_5", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String JDFX = DomHelper.getChildTextNotNull(row, "JDFX", ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7", (String)"DetailImpl_6", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String JYJE = DomHelper.getChildTextNotNull(row, "JYJE", ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_7", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String JYYE = DomHelper.getChildText(row, "JYYE");
            String BIZH = DomHelper.getChildTextNotNull(row, "BIZH", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DetailImpl_9", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String DFZH = DomHelper.getChildTextNotNull(row, "DFZH", ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7", (String)"DetailImpl_10", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String DFHM = DomHelper.getChildTextNotNull(row, "DFHM", ResManager.loadKDString((String)"\u5bf9\u65b9\u6237\u540d", (String)"DetailImpl_11", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String DFWD = DomHelper.getChildTextNotNull(row, "DFWD", ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7\u5f00\u6237\u884c", (String)"DetailImpl_12", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String BEZU = DomHelper.getChildTextNotNull(row, "BEZU", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"DetailImpl_13", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            String ZJLS = DomHelper.getChildTextNotNull(row, "ZJLS", ResManager.loadKDString((String)"\u4e3b\u673a\u6d41\u6c34\u53f7", (String)"DetailImpl_14", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detail.setAccName(bankDetailRequest.getAcnt().getAccName());
            detail.setOppAccNo(DFZH);
            detail.setOppAccName(DFHM);
            detail.setCurrency(BIZH);
            detail.setOppBankName(DFWD);
            if ("D".equalsIgnoreCase(JDFX)) {
                detail.setCreditAmount(new BigDecimal("0.00"));
                detail.setDebitAmount(BigDecimalHelper.add((String)"0.00", (String)JYJE));
            } else if ("C".equalsIgnoreCase(JDFX)) {
                detail.setCreditAmount(BigDecimalHelper.add((String)"0.00", (String)JYJE));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7:%s\u3002", (String)"DetailImpl_19", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), JDFX));
            }
            if (StringUtils.isNotEmpty((String)JYYE)) {
                detail.setBalance(BigDecimalHelper.add((String)"0.00", (String)JYYE));
            }
            detail.setExplanation(BEZU);
            detail.setTransDate(LocalDate.parse(JYRQ, DateTimeFormatter.ofPattern("yyyyMMdd")));
            if (StringUtils.isEmpty((String)JYSJ)) {
                detail.setTransTime(LocalDateTime.parse(JYRQ + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            } else {
                JYSJ = JYSJ.replace(":", "");
                detail.setTransTime(LocalDateTime.parse(JYRQ + JYSJ, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), JYRQ, jsonStr);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(ZJLS);
            detail.setReceiptNo(receiptNo);
            totalList.add(detail);
        }
        return new EBBankDetailResponse(totalList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "srv005_accountTradeInfoQuery";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u6237\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2 srv005_accountTradeInfoQuery\u3002", (String)"DetailImpl_16", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = RequestContextUtils.getCharset();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"uri"));
        factory.setHttpHeader("Content-Length", Integer.toString(this.contentLength));
        factory.setHttpHeader("Content-Type", "text/xml; charset=" + encoding);
    }
}

